/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import com.google.common.collect.ImmutableList;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.util.DelegatingScript;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.meter.analyzer.dsl.Expression;
import org.apache.skywalking.oap.meter.analyzer.dsl.registry.ProcessRegistry;
import org.apache.skywalking.oap.meter.analyzer.dsl.tagOpt.K8sRetagType;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;

public final class DSL {
    public static Expression parse(String metricName, String expression) {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(DelegatingScript.class.getName());
        ImportCustomizer icz = new ImportCustomizer();
        icz.addImport("K8sRetagType", K8sRetagType.class.getName());
        icz.addImport("DetectPoint", DetectPoint.class.getName());
        icz.addImport("Layer", Layer.class.getName());
        icz.addImport("ProcessRegistry", ProcessRegistry.class.getName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{icz});
        SecureASTCustomizer secureASTCustomizer = new SecureASTCustomizer();
        secureASTCustomizer.setDisallowedStatements((List)ImmutableList.builder().add(WhileStatement.class).add(DoWhileStatement.class).add(ForStatement.class).build());
        secureASTCustomizer.setAllowedReceiversClasses((List)ImmutableList.builder().add(Object.class).add(Map.class).add(List.class).add(Array.class).add(K8sRetagType.class).add(DetectPoint.class).add(Layer.class).add(ProcessRegistry.class).build());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{secureASTCustomizer});
        GroovyShell sh = new GroovyShell(new Binding(), cc);
        DelegatingScript script = (DelegatingScript)sh.parse(expression);
        return new Expression(metricName, expression, script);
    }
}

