/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.apache.skywalking.oap.meter.analyzer.dsl.DSL;
import org.apache.skywalking.oap.meter.analyzer.dsl.DownsamplingType;
import org.apache.skywalking.oap.meter.analyzer.dsl.Expression;
import org.apache.skywalking.oap.meter.analyzer.dsl.ExpressionParsingContext;
import org.apache.skywalking.oap.meter.analyzer.dsl.FilterExpression;
import org.apache.skywalking.oap.meter.analyzer.dsl.Result;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.endpoint.EndpointTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.instance.InstanceTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.process.ProcessRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.process.ProcessRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.service.ServiceRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.service.ServiceRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.service.ServiceTraffic;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.analysis.meter.ScopeType;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.BucketedValues;
import org.apache.skywalking.oap.server.core.analysis.meter.function.PercentileArgument;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);
    public static final Tuple2<String, SampleFamily> NIL = Tuple.of((Object)"", null);
    private List<String> samples;
    private final String metricName;
    private final FilterExpression filterExpression;
    private final Expression expression;
    private final MeterSystem meterSystem;
    private final ExpressionParsingContext ctx;
    private MetricType metricType;
    private int[] percentiles;

    public static Analyzer build(String metricName, String filterExpression, String expression, MeterSystem meterSystem) {
        Expression e = DSL.parse(metricName, expression);
        FilterExpression filter = null;
        if (!Strings.isNullOrEmpty((String)filterExpression)) {
            filter = new FilterExpression(filterExpression);
        }
        ExpressionParsingContext ctx = e.parse();
        Analyzer analyzer = new Analyzer(metricName, filter, e, meterSystem, ctx);
        analyzer.init();
        return analyzer;
    }

    public void analyse(ImmutableMap<String, SampleFamily> sampleFamilies) {
        Result r;
        Map<String, SampleFamily> input = (Map<String, SampleFamily>)this.samples.stream().map(s -> Tuple.of((Object)s, (Object)((SampleFamily)sampleFamilies.get(s)))).filter(t -> t._2 != null).collect(ImmutableMap.toImmutableMap(t -> (String)t._1, t -> (SampleFamily)t._2));
        if (input.size() < 1) {
            if (log.isDebugEnabled()) {
                log.debug("{} is ignored due to the lack of {}", (Object)this.expression, this.samples);
            }
            return;
        }
        if (this.filterExpression != null) {
            input = this.filterExpression.filter(input);
        }
        if (!(r = this.expression.run(input)).isSuccess()) {
            return;
        }
        SampleFamily.RunningContext ctx = r.getData().context;
        Map<MeterEntity, Sample[]> meterSamples = ctx.getMeterSamples();
        meterSamples.forEach((meterEntity, ss) -> {
            this.generateTraffic((MeterEntity)meterEntity);
            switch (this.metricType) {
                case single: {
                    AcceptableValue sv = this.meterSystem.buildMetrics(this.metricName, Long.class);
                    sv.accept(meterEntity, (Object)this.getValue(ss[0]));
                    this.send(sv, ss[0].getTimestamp());
                    break;
                }
                case labeled: {
                    AcceptableValue lv = this.meterSystem.buildMetrics(this.metricName, DataTable.class);
                    DataTable dt = new DataTable();
                    for (Sample each : ss) {
                        dt.put(this.composeGroup(each.getLabels()), Long.valueOf(this.getValue(each)));
                    }
                    lv.accept(meterEntity, (Object)dt);
                    this.send(lv, ss[0].getTimestamp());
                    break;
                }
                case histogram: 
                case histogramPercentile: {
                    Stream.of(ss).map(s -> Tuple.of((Object)this.composeGroup(s.getLabels(), k -> !Objects.equals("le", k)), (Object)s)).collect(Collectors.groupingBy(Tuple2::_1, Collectors.mapping(Tuple2::_2, Collectors.toList()))).forEach((group, subSs) -> {
                        if (subSs.size() < 1) {
                            return;
                        }
                        long[] bb = new long[subSs.size()];
                        long[] vv = new long[bb.length];
                        for (int i = 0; i < subSs.size(); ++i) {
                            Sample s = (Sample)subSs.get(i);
                            double leVal = Double.parseDouble((String)s.getLabels().get((Object)"le"));
                            bb[i] = leVal == Double.NEGATIVE_INFINITY ? Long.MIN_VALUE : (long)leVal;
                            vv[i] = this.getValue(s);
                        }
                        BucketedValues bv = new BucketedValues(bb, vv);
                        bv.setGroup(group);
                        long time = ((Sample)subSs.get(0)).getTimestamp();
                        if (this.metricType == MetricType.histogram) {
                            AcceptableValue v = this.meterSystem.buildMetrics(this.metricName, BucketedValues.class);
                            v.accept(meterEntity, (Object)bv);
                            this.send(v, time);
                            return;
                        }
                        AcceptableValue v = this.meterSystem.buildMetrics(this.metricName, PercentileArgument.class);
                        v.accept(meterEntity, (Object)new PercentileArgument(bv, this.percentiles));
                        this.send(v, time);
                    });
                }
            }
        });
    }

    private long getValue(Sample sample) {
        if (sample.getValue() <= 0.0) {
            return 0L;
        }
        if (sample.getValue() < 1.0) {
            return 1L;
        }
        return Math.round(sample.getValue());
    }

    private String composeGroup(ImmutableMap<String, String> labels) {
        return this.composeGroup(labels, k -> true);
    }

    private String composeGroup(ImmutableMap<String, String> labels, Predicate<String> filter) {
        return labels.keySet().stream().filter(filter).sorted().map(arg_0 -> labels.get(arg_0)).collect(Collectors.joining("-"));
    }

    private void init() {
        this.samples = this.ctx.getSamples();
        if (this.ctx.isHistogram()) {
            if (this.ctx.getPercentiles() != null && this.ctx.getPercentiles().length > 0) {
                this.metricType = MetricType.histogramPercentile;
                this.percentiles = this.ctx.getPercentiles();
            } else {
                this.metricType = MetricType.histogram;
            }
        } else {
            this.metricType = this.ctx.getLabels().isEmpty() ? MetricType.single : MetricType.labeled;
        }
        this.createMetric(this.ctx.getScopeType(), this.metricType.literal, this.ctx.getDownsampling());
    }

    private void createMetric(ScopeType scopeType, String dataType, DownsamplingType downsamplingType) {
        String downSamplingStr = CaseUtils.toCamelCase((String)downsamplingType.toString().toLowerCase(), (boolean)false, (char[])new char[]{'_'});
        String functionName = String.format("%s%s", downSamplingStr, StringUtils.capitalize((String)dataType));
        this.meterSystem.create(this.metricName, functionName, scopeType);
    }

    private void send(AcceptableValue<?> v, long time) {
        v.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)time));
        this.meterSystem.doStreamingCalculation(v);
    }

    private void generateTraffic(MeterEntity entity) {
        if (entity.getDetectPoint() != null) {
            switch (entity.getScopeType()) {
                case SERVICE_RELATION: {
                    this.serviceRelationTraffic(entity);
                    break;
                }
                case PROCESS_RELATION: {
                    this.processRelationTraffic(entity);
                    break;
                }
            }
        } else {
            this.toService(Objects.requireNonNull(entity.getServiceName()), entity.getLayer());
        }
        if (!Strings.isNullOrEmpty((String)entity.getInstanceName())) {
            InstanceTraffic instanceTraffic = new InstanceTraffic();
            instanceTraffic.setName(entity.getInstanceName());
            instanceTraffic.setServiceId(entity.serviceId());
            instanceTraffic.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
            instanceTraffic.setLastPingTimestamp(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
            if (entity.getInstanceProperties() != null && !entity.getInstanceProperties().isEmpty()) {
                JsonObject properties = new JsonObject();
                entity.getInstanceProperties().forEach((k, v) -> properties.addProperty(k, v));
                instanceTraffic.setProperties(properties);
            }
            MetricsStreamProcessor.getInstance().in((Metrics)instanceTraffic);
        }
        if (!Strings.isNullOrEmpty((String)entity.getEndpointName())) {
            EndpointTraffic endpointTraffic = new EndpointTraffic();
            endpointTraffic.setName(entity.getEndpointName());
            endpointTraffic.setServiceId(entity.serviceId());
            endpointTraffic.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
            MetricsStreamProcessor.getInstance().in((Metrics)endpointTraffic);
        }
    }

    private void toService(String serviceName, Layer layer) {
        ServiceTraffic s = new ServiceTraffic();
        s.setName(Objects.requireNonNull(serviceName));
        s.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        s.setLayer(layer);
        MetricsStreamProcessor.getInstance().in((Metrics)s);
    }

    private void serviceRelationTraffic(MeterEntity entity) {
        switch (entity.getDetectPoint()) {
            case SERVER: {
                entity.setServiceName(entity.getDestServiceName());
                this.toService(Objects.requireNonNull(entity.getDestServiceName()), entity.getLayer());
                this.serviceRelationServerSide(entity);
                break;
            }
            case CLIENT: {
                entity.setServiceName(entity.getSourceServiceName());
                this.toService(Objects.requireNonNull(entity.getSourceServiceName()), entity.getLayer());
                this.serviceRelationClientSide(entity);
                break;
            }
        }
    }

    private void serviceRelationServerSide(MeterEntity entity) {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        metrics.setSourceServiceId(entity.sourceServiceId());
        metrics.setDestServiceId(entity.destServiceId());
        metrics.getComponentIds().add(entity.getComponentId());
        metrics.setEntityId(entity.id());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void serviceRelationClientSide(MeterEntity entity) {
        ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        metrics.setSourceServiceId(entity.sourceServiceId());
        metrics.setDestServiceId(entity.destServiceId());
        metrics.getComponentIds().add(entity.getComponentId());
        metrics.setEntityId(entity.id());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void processRelationTraffic(MeterEntity entity) {
        switch (entity.getDetectPoint()) {
            case SERVER: {
                this.processRelationServerSide(entity);
                break;
            }
            case CLIENT: {
                this.processRelationClientSide(entity);
                break;
            }
        }
    }

    private void processRelationServerSide(MeterEntity entity) {
        ProcessRelationServerSideMetrics metrics = new ProcessRelationServerSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        metrics.setServiceInstanceId(entity.serviceInstanceId());
        metrics.setSourceProcessId(entity.getSourceProcessId());
        metrics.setDestProcessId(entity.getDestProcessId());
        metrics.setEntityId(entity.id());
        metrics.setComponentId(entity.getComponentId());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void processRelationClientSide(MeterEntity entity) {
        ProcessRelationClientSideMetrics metrics = new ProcessRelationClientSideMetrics();
        metrics.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        metrics.setServiceInstanceId(entity.serviceInstanceId());
        metrics.setSourceProcessId(entity.getSourceProcessId());
        metrics.setDestProcessId(entity.getDestProcessId());
        metrics.setEntityId(entity.id());
        metrics.setComponentId(entity.getComponentId());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    @Generated
    private Analyzer(String metricName, FilterExpression filterExpression, Expression expression, MeterSystem meterSystem, ExpressionParsingContext ctx) {
        this.metricName = metricName;
        this.filterExpression = filterExpression;
        this.expression = expression;
        this.meterSystem = meterSystem;
        this.ctx = ctx;
    }

    @Generated
    public String toString() {
        return "Analyzer(metricName=" + this.metricName + ", expression=" + this.expression + ")";
    }

    private static enum MetricType {
        histogram("histogram"),
        histogramPercentile("histogramPercentile"),
        labeled("labeled"),
        single("");

        private final String literal;

        @Generated
        private MetricType(String literal) {
            this.literal = literal;
        }
    }
}

