/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.websocket;

import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.internal.common.RequestContextExtension;
import com.linecorp.armeria.internal.common.websocket.WebSocketFrameDecoder;
import com.linecorp.armeria.server.ServiceRequestContext;

final class WebSocketServiceFrameDecoder
extends WebSocketFrameDecoder {
    private final ServiceRequestContext ctx;

    WebSocketServiceFrameDecoder(ServiceRequestContext ctx, int maxFramePayloadLength, boolean allowMaskMismatch) {
        super(ctx, maxFramePayloadLength, allowMaskMismatch);
        this.ctx = ctx;
    }

    @Override
    protected boolean expectMaskedFrames() {
        return true;
    }

    @Override
    protected void onCloseFrameRead() {
        RequestContextExtension ctxExtension = this.ctx.as(RequestContextExtension.class);
        assert (ctxExtension != null);
        Request request = ctxExtension.originalRequest();
        assert (request instanceof HttpRequestWriter) : request;
        ((HttpRequestWriter)request).close();
    }
}

