/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.websocket;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.websocket.WebSocketService;
import com.linecorp.armeria.server.websocket.WebSocketServiceHandler;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class WebSocketServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServiceBuilder.class);
    private static final String ANY_ORIGIN = "*";
    static final int DEFAULT_MAX_FRAME_PAYLOAD_LENGTH = 65535;
    private final WebSocketServiceHandler handler;
    private int maxFramePayloadLength = 65535;
    private boolean allowMaskMismatch;
    private Set<String> subprotocols = ImmutableSet.of();
    private Set<String> allowedOrigins = ImmutableSet.of();

    WebSocketServiceBuilder(WebSocketServiceHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    public WebSocketServiceBuilder maxFramePayloadLength(int maxFramePayloadLength) {
        Preconditions.checkArgument(maxFramePayloadLength > 0, "maxFramePayloadLength: %s (expected: > 0)", maxFramePayloadLength);
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    public WebSocketServiceBuilder allowMaskMismatch(boolean allowMaskMismatch) {
        this.allowMaskMismatch = allowMaskMismatch;
        return this;
    }

    public WebSocketServiceBuilder subprotocols(String ... subprotocols) {
        return this.subprotocols(ImmutableSet.copyOf(Objects.requireNonNull(subprotocols, "subprotocols")));
    }

    public WebSocketServiceBuilder subprotocols(Iterable<String> subprotocols) {
        this.subprotocols = ImmutableSet.copyOf(Objects.requireNonNull(subprotocols, "subprotocols"));
        return this;
    }

    public WebSocketServiceBuilder allowedOrigins(String ... allowedOrigins) {
        return this.allowedOrigins(ImmutableSet.copyOf(Objects.requireNonNull(allowedOrigins, "allowedOrigins")));
    }

    public WebSocketServiceBuilder allowedOrigins(Iterable<String> allowedOrigins) {
        this.allowedOrigins = WebSocketServiceBuilder.validateOrigins(allowedOrigins);
        return this;
    }

    private static Set<String> validateOrigins(Iterable<String> allowedOrigins) {
        ImmutableSet<String> copied = ImmutableSet.copyOf(Objects.requireNonNull(allowedOrigins, "allowedOrigins"));
        Preconditions.checkArgument(!copied.isEmpty(), "allowedOrigins is empty. (expected: non-empty)");
        if (copied.contains(ANY_ORIGIN) && copied.size() > 1) {
            logger.warn("Any origin (*) has been already included. Other origins ({}) will be ignored.", (Object)copied.stream().filter(c -> !ANY_ORIGIN.equals(c)).collect(Collectors.joining(",")));
        }
        return copied;
    }

    public WebSocketService build() {
        return new WebSocketService(this.handler, this.maxFramePayloadLength, this.allowMaskMismatch, this.subprotocols, this.allowedOrigins, this.allowedOrigins.contains(ANY_ORIGIN));
    }
}

