/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http2ObjectEncoder;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.server.Http2ServerKeepAliveHandler;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;

final class ServerHttp2ObjectEncoder
extends Http2ObjectEncoder
implements ServerHttpObjectEncoder {
    private final boolean enableServerHeader;
    private final boolean enableDateHeader;

    ServerHttp2ObjectEncoder(ChannelHandlerContext connectionHandlerCtx, AbstractHttp2ConnectionHandler connectionHandler, boolean enableDateHeader, boolean enableServerHeader) {
        super(connectionHandlerCtx, connectionHandler);
        assert (this.keepAliveHandler() instanceof Http2ServerKeepAliveHandler || this.keepAliveHandler() instanceof NoopKeepAliveHandler);
        this.enableServerHeader = enableServerHeader;
        this.enableDateHeader = enableDateHeader;
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty) {
        if (!this.isStreamPresentAndWritable(streamId) || this.isResponseHeadersSent(id, streamId)) {
            return this.newFailedFuture(ClosedStreamException.get());
        }
        Http2Headers converted = ServerHttp2ObjectEncoder.convertHeaders(headers, isTrailersEmpty);
        this.onKeepAliveReadOrWrite();
        return this.encoder().writeHeaders(this.ctx(), streamId, converted, 0, endStream, this.ctx().newPromise());
    }

    @Override
    public boolean isResponseHeadersSent(int id, int streamId) {
        Http2Stream stream = this.findStream(streamId);
        if (stream == null) {
            return false;
        }
        return stream.isHeadersSent();
    }

    @Nullable
    Http2Stream findStream(int streamId) {
        return this.encoder().connection().stream(streamId);
    }

    private static Http2Headers convertHeaders(ResponseHeaders inputHeaders, boolean isTrailersEmpty) {
        ResponseHeadersBuilder builder = inputHeaders.toBuilder();
        if (!isTrailersEmpty && inputHeaders.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            builder.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        return ArmeriaHttpUtil.toNettyHttp2ServerHeaders(builder);
    }

    @Override
    public ChannelFuture doWriteTrailers(int id, int streamId, HttpHeaders headers) {
        if (!this.isStreamPresentAndWritable(streamId)) {
            return this.newFailedFuture(ClosedStreamException.get());
        }
        Http2Headers converted = ArmeriaHttpUtil.toNettyHttp2ServerTrailers(headers);
        this.onKeepAliveReadOrWrite();
        return this.encoder().writeHeaders(this.ctx(), streamId, converted, 0, true, this.ctx().newPromise());
    }

    private void onKeepAliveReadOrWrite() {
        this.keepAliveHandler().onReadOrWrite();
    }

    @Override
    public ChannelFuture writeErrorResponse(int id, int streamId, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        ChannelFuture future = ServerHttpObjectEncoder.super.writeErrorResponse(id, streamId, serviceConfig, headers, status, message, cause);
        Http2Stream stream = this.findStream(streamId);
        if (stream != null) {
            Http2RemoteFlowController flowController = this.encoder().flowController();
            if (flowController.hasFlowControlled(stream)) {
                try {
                    flowController.writePendingBytes();
                }
                catch (Http2Exception http2Exception) {
                    // empty catch block
                }
            }
            if (stream.state().localSideOpen()) {
                future = this.encoder().writeRstStream(this.ctx(), streamId, Http2Error.CANCEL.code(), this.ctx().voidPromise());
                this.ctx().flush();
            }
        }
        return future;
    }
}

