/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.CancellationException;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.EmptyHttpResponseException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.AbstractHttpResponseHandler;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpServerHandler;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AggregatedHttpResponseHandler
extends AbstractHttpResponseHandler
implements BiFunction<AggregatedHttpResponse, Throwable, Void> {
    private static final Logger logger = LoggerFactory.getLogger(AggregatedHttpResponseHandler.class);

    AggregatedHttpResponseHandler(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
        this.scheduleTimeout();
    }

    @Override
    public Void apply(@Nullable AggregatedHttpResponse response, @Nullable Throwable cause) {
        ContextAwareEventLoop eventLoop = this.reqCtx.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.apply0(response, cause);
        } else {
            eventLoop.execute(() -> this.apply0(response, cause));
        }
        return null;
    }

    private void apply0(@Nullable AggregatedHttpResponse response, @Nullable Throwable cause) {
        this.clearTimeout();
        if (cause != null) {
            cause = Exceptions.peel(cause);
            this.recoverAndWrite(cause);
            return;
        }
        assert (response != null);
        if (this.failIfStreamOrSessionClosed()) {
            response.content().close();
            return;
        }
        this.logBuilder().startResponse();
        this.write(response, null);
    }

    private void write(AggregatedHttpResponse response, @Nullable Throwable cause) {
        ChannelFuture future = this.writeAggregatedHttpResponse(response);
        future.addListener(new WriteFutureListener(response.content().isEmpty(), cause));
        this.ctx.flush();
    }

    private void recoverAndWrite(Throwable cause) {
        if (cause instanceof HttpResponseException) {
            this.toAggregatedHttpResponse((HttpResponseException)cause).handleAsync((res, cause0) -> {
                if (cause0 != null) {
                    cause0 = Exceptions.peel(cause0);
                    this.write(internalServerErrorResponse, (Throwable)cause0);
                } else {
                    this.write((AggregatedHttpResponse)res, cause);
                }
                return null;
            }, (Executor)this.ctx.executor());
        } else if (cause instanceof HttpStatusException) {
            Throwable cause02 = MoreObjects.firstNonNull(cause.getCause(), cause);
            this.write(this.toAggregatedHttpResponse((HttpStatusException)cause), cause02);
        } else if (Exceptions.isStreamCancelling(cause) || cause instanceof EmptyHttpResponseException) {
            this.resetAndFail(cause);
        } else {
            if (!(cause instanceof CancellationException)) {
                logger.warn("{} Unexpected exception from a service or a response publisher: {}", this.ctx.channel(), this.service(), cause);
            }
            this.write(internalServerErrorResponse, cause);
        }
    }

    @Override
    void fail(Throwable cause) {
        if (this.tryComplete(cause)) {
            this.endLogRequestAndResponse(cause);
            this.maybeWriteAccessLog();
        }
    }

    private void resetAndFail(Throwable cause) {
        this.responseEncoder.writeReset(this.req.id(), this.req.streamId(), Http2Error.CANCEL).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                this.fail(cause);
            }
        }));
        this.ctx.flush();
    }

    void handleWriteComplete(ChannelFuture future, boolean isSuccess, @Nullable Throwable cause) throws Exception {
        if (isSuccess) {
            this.logBuilder().responseFirstBytesTransferred();
            if (this.tryComplete(cause)) {
                RequestLog requestLog;
                if (cause == null && (requestLog = this.reqCtx.log().getIfAvailable(RequestLogProperty.RESPONSE_CAUSE)) != null) {
                    cause = requestLog.responseCause();
                }
                this.endLogRequestAndResponse(cause);
                this.maybeWriteAccessLog();
            }
            return;
        }
        this.fail(future.cause());
        HttpServerHandler.CLOSE_ON_FAILURE.operationComplete(future);
    }

    private final class WriteFutureListener
    implements ChannelFutureListener {
        private final boolean wroteEmptyData;
        @Nullable
        private final Throwable cause;

        WriteFutureListener(@Nullable boolean wroteEmptyData, Throwable cause) {
            this.wroteEmptyData = wroteEmptyData;
            this.cause = cause;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                boolean isSuccess = future.isSuccess() ? true : this.wroteEmptyData && future.cause() instanceof ClosedChannelException && AggregatedHttpResponseHandler.this.responseEncoder instanceof Http1ObjectEncoder;
                AggregatedHttpResponseHandler.this.handleWriteComplete(future, isSuccess, this.cause);
            }
        }
    }
}

