/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec;

import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.AbstractECLookupTable;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECFieldElement;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECLookupTable;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP192R1Field;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP192R1FieldElement;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP192R1Point;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.raw.Nat192;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP192R1FieldElement.Q;
    private static final ECFieldElement[] SECP192R1_AFFINE_ZS = new ECFieldElement[]{new SecP192R1FieldElement(ECConstants.ONE)};
    protected SecP192R1Point infinity = new SecP192R1Point(this, null, null);

    public SecP192R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP192R1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP192R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP192R1Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP192R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 6 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat192.copy(((SecP192R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat192.copy(((SecP192R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 6);
            n3 += 6;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat192.create();
                int[] nArray2 = Nat192.create();
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 6; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 6 + j] & n3;
                    }
                    n22 += 12;
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return SecP192R1Curve.this.createRawPoint(new SecP192R1FieldElement(nArray3), new SecP192R1FieldElement(nArray2), SECP192R1_AFFINE_ZS);
            }
        };
    }

    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat192.create();
        SecP192R1Field.randomMult(secureRandom, nArray);
        return new SecP192R1FieldElement(nArray);
    }
}

