/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.websocket;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketFrame;
import com.linecorp.armeria.internal.shaded.guava.hash.Hashing;
import com.linecorp.armeria.server.websocket.WebSocketProtocolViolationException;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public final class WebSocketUtil {
    private static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final long DEFAULT_REQUEST_RESPONSE_TIMEOUT_MILLIS = 0L;
    public static final long DEFAULT_MAX_REQUEST_RESPONSE_LENGTH = 0L;
    public static final long DEFAULT_REQUEST_AUTO_ABORT_DELAY_MILLIS = 5000L;

    public static boolean isHttp1WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.GET && HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase(headers.get(HttpHeaderNames.CONNECTION)) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(headers.get(HttpHeaderNames.UPGRADE));
    }

    public static boolean isHttp2WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.CONNECT && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(headers.get(HttpHeaderNames.PROTOCOL));
    }

    public static String generateSecWebSocketAccept(String webSocketKey) {
        String acceptSeed = webSocketKey + MAGIC_GUID;
        byte[] sha1 = Hashing.sha1().hashBytes(acceptSeed.getBytes(StandardCharsets.US_ASCII)).asBytes();
        return Base64.getEncoder().encodeToString(sha1);
    }

    static int byteAtIndex(int mask, int index) {
        return mask >> 8 * (3 - index) & 0xFF;
    }

    public static CloseWebSocketFrame newCloseWebSocketFrame(Throwable cause) {
        WebSocketCloseStatus closeStatus = cause instanceof WebSocketProtocolViolationException ? ((WebSocketProtocolViolationException)cause).closeStatus() : WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        String reasonPhrase = cause.getMessage();
        if (reasonPhrase == null) {
            reasonPhrase = closeStatus.reasonPhrase();
        }
        return WebSocketFrame.ofClose(closeStatus, reasonPhrase);
    }

    private WebSocketUtil() {
    }
}

