/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.websocket;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.common.stream.StreamDecoderOutput;
import com.linecorp.armeria.common.websocket.WebSocket;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketFrameType;
import com.linecorp.armeria.internal.common.websocket.Utf8Validator;
import com.linecorp.armeria.internal.common.websocket.WebSocketUtil;
import com.linecorp.armeria.server.websocket.WebSocketProtocolViolationException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketFrameDecoder
implements HttpDecoder<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketFrameDecoder.class);
    private final RequestContext ctx;
    private final int maxFramePayloadLength;
    private final boolean allowMaskMismatch;
    @Nullable
    private WebSocket outboundFrames;
    private int fragmentedFramesCount;
    private boolean finalFragment;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private int mask;
    private int framePayloadLen1;
    private boolean receivedClosingHandshake;
    private State state = State.READING_FIRST;

    protected WebSocketFrameDecoder(RequestContext ctx, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this.ctx = ctx;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    public void setOutboundWebSocket(WebSocket outboundFrames) {
        this.outboundFrames = outboundFrames;
    }

    @Override
    public void process(StreamDecoderInput in, StreamDecoderOutput<WebSocketFrame> out) throws Exception {
        block7: while (in.readableBytes() > 0) {
            if (this.receivedClosingHandshake) {
                in.close();
                return;
            }
            switch (this.state) {
                case READING_FIRST: {
                    this.framePayloadLength = 0L;
                    byte b = in.readByte();
                    this.finalFragment = (b & 0x80) != 0;
                    this.frameRsv = (b & 0x70) >> 4;
                    this.frameOpcode = b & 0xF;
                    logger.trace("Decoding a WebSocket Frame. opcode: {}, finalFragment: {}", (Object)this.frameOpcode, (Object)this.finalFragment);
                    this.state = State.READING_SECOND;
                }
                case READING_SECOND: {
                    if (in.readableBytes() == 0) {
                        return;
                    }
                    byte b = in.readByte();
                    this.frameMasked = (b & 0x80) != 0;
                    this.framePayloadLen1 = b & 0x7F;
                    if (this.frameRsv != 0) {
                        throw this.protocolViolation("RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    }
                    if (!this.allowMaskMismatch && this.expectMaskedFrames() != this.frameMasked) {
                        throw this.protocolViolation("received a frame that is not masked as expected");
                    }
                    if (this.frameOpcode > 7) {
                        if (!this.finalFragment) {
                            throw this.protocolViolation("fragmented control frame");
                        }
                        if (this.framePayloadLen1 > 125) {
                            throw this.protocolViolation("control frame with payload length > 125 octets");
                        }
                        if (this.frameOpcode != WebSocketFrameType.CLOSE.opcode() && this.frameOpcode != WebSocketFrameType.PING.opcode() && this.frameOpcode != WebSocketFrameType.PONG.opcode()) {
                            throw this.protocolViolation("control frame using reserved opcode " + this.frameOpcode);
                        }
                        if (this.frameOpcode == WebSocketFrameType.CLOSE.opcode() && this.framePayloadLen1 == 1) {
                            throw this.protocolViolation("received close control frame with payload len 1");
                        }
                    } else {
                        if (this.frameOpcode != WebSocketFrameType.CONTINUATION.opcode() && this.frameOpcode != WebSocketFrameType.TEXT.opcode() && this.frameOpcode != WebSocketFrameType.BINARY.opcode()) {
                            throw this.protocolViolation("data frame using reserved opcode " + this.frameOpcode);
                        }
                        if (this.fragmentedFramesCount == 0) {
                            if (this.frameOpcode == WebSocketFrameType.CONTINUATION.opcode()) {
                                throw this.protocolViolation("received continuation data frame outside fragmented message");
                            }
                        } else if (this.frameOpcode != WebSocketFrameType.CONTINUATION.opcode()) {
                            throw this.protocolViolation("received non-continuation data frame while inside fragmented message");
                        }
                    }
                    this.state = State.READING_SIZE;
                }
                case READING_SIZE: {
                    if (this.framePayloadLen1 == 126) {
                        if (in.readableBytes() < 2) {
                            return;
                        }
                        this.framePayloadLength = in.readUnsignedShort();
                        if (this.framePayloadLength < 126L) {
                            throw this.protocolViolation("invalid data frame length (not using minimal length encoding)");
                        }
                    } else if (this.framePayloadLen1 == 127) {
                        if (in.readableBytes() < 8) {
                            return;
                        }
                        this.framePayloadLength = in.readLong();
                        if (this.framePayloadLength < 0L) {
                            throw this.protocolViolation("invalid data frame length (negative length)");
                        }
                        if (this.framePayloadLength < 65536L) {
                            throw this.protocolViolation("invalid data frame length (not using minimal length encoding)");
                        }
                    } else {
                        this.framePayloadLength = this.framePayloadLen1;
                    }
                    if (this.framePayloadLength > (long)this.maxFramePayloadLength) {
                        throw this.protocolViolation(WebSocketCloseStatus.MESSAGE_TOO_BIG, "Max frame length of " + this.maxFramePayloadLength + " has been exceeded.");
                    }
                    logger.trace("Decoding a WebSocket Frame. length: {}", (Object)this.framePayloadLength);
                    this.state = State.MASKING_KEY;
                }
                case MASKING_KEY: {
                    if (this.frameMasked) {
                        if (in.readableBytes() < 4) {
                            return;
                        }
                        this.mask = in.readInt();
                    }
                    this.state = State.PAYLOAD;
                }
                case PAYLOAD: {
                    WebSocketFrame decodedFrame;
                    if ((long)in.readableBytes() < this.framePayloadLength) {
                        return;
                    }
                    ByteBuf payloadBuffer = Unpooled.EMPTY_BUFFER;
                    if (this.framePayloadLength > 0L) {
                        payloadBuffer = in.readBytes(WebSocketFrameDecoder.toFrameLength(this.framePayloadLength));
                    }
                    this.state = State.READING_FIRST;
                    if (this.frameMasked & this.framePayloadLength > 0L) {
                        this.unmask(payloadBuffer);
                    }
                    if (this.frameOpcode == WebSocketFrameType.PING.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledPing(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        continue block7;
                    }
                    assert (payloadBuffer != null);
                    if (this.frameOpcode == WebSocketFrameType.PONG.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledPong(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        continue block7;
                    }
                    if (this.frameOpcode == WebSocketFrameType.CLOSE.opcode()) {
                        this.receivedClosingHandshake = true;
                        this.validateCloseFrame(payloadBuffer);
                        decodedFrame = WebSocketFrame.ofPooledClose(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        this.onCloseFrameRead();
                        continue block7;
                    }
                    if (this.frameOpcode == WebSocketFrameType.TEXT.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledText(payloadBuffer, this.finalFragment);
                        out.add(decodedFrame);
                    } else if (this.frameOpcode == WebSocketFrameType.BINARY.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledBinary(payloadBuffer, this.finalFragment);
                        out.add(decodedFrame);
                    } else if (this.frameOpcode == WebSocketFrameType.CONTINUATION.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledContinuation(payloadBuffer, this.finalFragment);
                        out.add(decodedFrame);
                    } else {
                        throw this.protocolViolation(WebSocketCloseStatus.INVALID_MESSAGE_TYPE, "Cannot decode a web socket frame with opcode: " + this.frameOpcode);
                    }
                    logger.trace("{} is decoded.", (Object)decodedFrame);
                    if (this.finalFragment) {
                        this.fragmentedFramesCount = 0;
                        continue block7;
                    }
                    ++this.fragmentedFramesCount;
                    continue block7;
                }
            }
            throw new Error("Shouldn't reach here.");
        }
    }

    protected abstract boolean expectMaskedFrames();

    protected abstract void onCloseFrameRead();

    private void unmask(ByteBuf frame) {
        int i;
        long longMask = (long)this.mask & 0xFFFFFFFFL;
        longMask |= longMask << 32;
        int end = frame.writerIndex();
        int lim = end - 7;
        for (i = frame.readerIndex(); i < lim; i += 8) {
            frame.setLong(i, frame.getLong(i) ^ longMask);
        }
        if (i < end - 3) {
            frame.setInt(i, frame.getInt(i) ^ (int)longMask);
            i += 4;
        }
        int maskOffset = 0;
        while (i < end) {
            frame.setByte(i, frame.getByte(i) ^ WebSocketUtil.byteAtIndex(this.mask, maskOffset++ & 3));
            ++i;
        }
    }

    private WebSocketProtocolViolationException protocolViolation(String message) {
        return this.protocolViolation(WebSocketCloseStatus.PROTOCOL_ERROR, message);
    }

    private WebSocketProtocolViolationException protocolViolation(WebSocketCloseStatus status, String message) {
        this.state = State.CORRUPT;
        return new WebSocketProtocolViolationException(status, message);
    }

    private static int toFrameLength(long l) {
        return (int)l;
    }

    private void validateCloseFrame(ByteBuf buffer) {
        block6: {
            try {
                if (buffer.readableBytes() < 2) {
                    throw this.protocolViolation(WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "Invalid close frame body");
                }
                short statusCode = buffer.getShort(buffer.readerIndex());
                if (!WebSocketCloseStatus.isValidStatusCode(statusCode)) {
                    throw this.protocolViolation("Invalid close frame status code: " + statusCode);
                }
                if (buffer.readableBytes() <= 2) break block6;
                try {
                    new Utf8Validator().check(buffer, buffer.readerIndex() + 2, buffer.readableBytes() - 2);
                }
                catch (IllegalArgumentException ex) {
                    throw this.protocolViolation(WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "bytes are not UTF-8");
                }
            }
            catch (Exception e) {
                buffer.release();
                throw e;
            }
        }
    }

    @Override
    public void processOnError(Throwable cause) {
        if (!this.receivedClosingHandshake && this.outboundFrames != null) {
            this.outboundFrames.abort(cause);
        }
        this.onProcessOnError(cause);
    }

    protected void onProcessOnError(Throwable cause) {
    }

    static enum State {
        READING_FIRST,
        READING_SECOND,
        READING_SIZE,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

