/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.metric;

import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.WriteTimeoutException;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import com.linecorp.armeria.server.RequestTimeoutException;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class RequestMetricSupport {
    public static void setup(RequestContext ctx, AttributeKey<Boolean> requestMetricsSetKey, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction) {
        Boolean isRequestMetricsSet = ctx.attr(requestMetricsSetKey);
        if (Boolean.TRUE.equals(isRequestMetricsSet)) {
            return;
        }
        ctx.setAttr(requestMetricsSetKey, true);
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_START_TIME, RequestLogProperty.REQUEST_HEADERS, RequestLogProperty.NAME, RequestLogProperty.SESSION).thenAccept(log -> RequestMetricSupport.onRequest(log, meterIdPrefixFunction, server, successFunction));
    }

    private static void onRequest(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction) {
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix activeRequestsId = meterIdPrefixFunction.activeRequestPrefix(registry, log).append("active.requests");
        ActiveRequestMetrics activeRequestMetrics = MicrometerUtil.register(registry, activeRequestsId, ActiveRequestMetrics.class, (reg, prefix) -> reg.gauge(prefix.name(), prefix.tags(), new ActiveRequestMetrics(), LongAdder::doubleValue));
        activeRequestMetrics.increment();
        ctx.log().whenComplete().thenAccept(requestLog -> {
            RequestMetricSupport.onResponse(requestLog, meterIdPrefixFunction, server, successFunction);
            activeRequestMetrics.decrement();
        });
    }

    private static void onResponse(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction) {
        int childrenSize;
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix idPrefix = meterIdPrefixFunction.completeRequestPrefix(registry, log);
        boolean isSuccess = successFunction.isSuccess(ctx, log);
        if (server) {
            ServiceRequestMetrics metrics = MicrometerUtil.register(registry, idPrefix, ServiceRequestMetrics.class, DefaultServiceRequestMetrics::new);
            RequestMetricSupport.updateMetrics(log, metrics, isSuccess);
            if (log.responseCause() instanceof RequestTimeoutException) {
                metrics.requestTimeouts().increment();
            }
            return;
        }
        ClientRequestMetrics metrics = MicrometerUtil.register(registry, idPrefix, ClientRequestMetrics.class, DefaultClientRequestMetrics::new);
        RequestMetricSupport.updateMetrics(log, metrics, isSuccess);
        ClientConnectionTimings timings = log.connectionTimings();
        if (timings != null) {
            long pendingAcquisitionDurationNanos;
            long socketConnectDurationNanos;
            metrics.connectionAcquisitionDuration().record(timings.connectionAcquisitionDurationNanos(), TimeUnit.NANOSECONDS);
            long dnsResolutionDurationNanos = timings.dnsResolutionDurationNanos();
            if (dnsResolutionDurationNanos >= 0L) {
                metrics.dnsResolutionDuration().record(dnsResolutionDurationNanos, TimeUnit.NANOSECONDS);
            }
            if ((socketConnectDurationNanos = timings.socketConnectDurationNanos()) >= 0L) {
                metrics.socketConnectDuration().record(socketConnectDurationNanos, TimeUnit.NANOSECONDS);
            }
            if ((pendingAcquisitionDurationNanos = timings.pendingAcquisitionDurationNanos()) >= 0L) {
                metrics.pendingAcquisitionDuration().record(pendingAcquisitionDurationNanos, TimeUnit.NANOSECONDS);
            }
        }
        if (log.requestCause() != null && log.requestCause() instanceof WriteTimeoutException) {
            metrics.writeTimeouts().increment();
        }
        if (log.responseCause() instanceof ResponseTimeoutException) {
            metrics.responseTimeouts().increment();
        }
        if ((childrenSize = log.children().size()) > 0) {
            RequestMetricSupport.updateRetryingClientMetrics(metrics, childrenSize, isSuccess);
        }
    }

    private static void updateMetrics(RequestLog log, RequestMetrics metrics, boolean isSuccess) {
        metrics.requestDuration().record(log.requestDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.requestLength().record(log.requestLength());
        metrics.responseDuration().record(log.responseDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.responseLength().record(log.responseLength());
        metrics.totalDuration().record(log.totalDurationNanos(), TimeUnit.NANOSECONDS);
        if (isSuccess) {
            metrics.success().increment();
        } else {
            metrics.failure().increment();
        }
    }

    private static void updateRetryingClientMetrics(ClientRequestMetrics metrics, int childrenSize, boolean isSuccess) {
        metrics.actualRequests().increment(childrenSize);
        if (isSuccess) {
            metrics.successAttempts().record(childrenSize);
        } else {
            metrics.failureAttempts().record(childrenSize);
        }
    }

    private RequestMetricSupport() {
    }

    private static final class ActiveRequestMetrics
    extends LongAdder {
        private ActiveRequestMetrics() {
        }
    }

    private static interface ServiceRequestMetrics
    extends RequestMetrics {
        public Counter requestTimeouts();
    }

    private static interface RequestMetrics {
        public Counter success();

        public Counter failure();

        public Timer requestDuration();

        public DistributionSummary requestLength();

        public Timer responseDuration();

        public DistributionSummary responseLength();

        public Timer totalDuration();
    }

    private static interface ClientRequestMetrics
    extends RequestMetrics {
        public Counter actualRequests();

        public Timer connectionAcquisitionDuration();

        public Timer dnsResolutionDuration();

        public Timer socketConnectDuration();

        public Timer pendingAcquisitionDuration();

        public Counter writeTimeouts();

        public Counter responseTimeouts();

        public DistributionSummary successAttempts();

        public DistributionSummary failureAttempts();
    }

    private static class DefaultServiceRequestMetrics
    extends AbstractRequestMetrics
    implements ServiceRequestMetrics {
        private final Counter requestTimeouts;

        DefaultServiceRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
            super(parent, idPrefix);
            this.requestTimeouts = parent.counter(idPrefix.name("timeouts"), idPrefix.tags("cause", "RequestTimeoutException"));
        }

        @Override
        public Counter requestTimeouts() {
            return this.requestTimeouts;
        }
    }

    private static class DefaultClientRequestMetrics
    extends AbstractRequestMetrics
    implements ClientRequestMetrics {
        private final MeterRegistry parent;
        private final MeterIdPrefix idPrefix;
        private final Timer connectionAcquisitionDuration;
        private final Timer dnsResolutionDuration;
        private final Timer socketConnectDuration;
        private final Timer pendingAcquisitionDuration;
        private final Counter writeTimeouts;
        private final Counter responseTimeouts;
        @Nullable
        private Counter actualRequests;
        @Nullable
        private DistributionSummary successAttempts;
        @Nullable
        private DistributionSummary failureAttempts;

        DefaultClientRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
            super(parent, idPrefix);
            this.parent = parent;
            this.idPrefix = idPrefix;
            this.connectionAcquisitionDuration = MoreMeters.newTimer(parent, idPrefix.name("connection.acquisition.duration"), idPrefix.tags());
            this.dnsResolutionDuration = MoreMeters.newTimer(parent, idPrefix.name("dns.resolution.duration"), idPrefix.tags());
            this.socketConnectDuration = MoreMeters.newTimer(parent, idPrefix.name("socket.connect.duration"), idPrefix.tags());
            this.pendingAcquisitionDuration = MoreMeters.newTimer(parent, idPrefix.name("pending.acquisition.duration"), idPrefix.tags());
            String timeouts = idPrefix.name("timeouts");
            this.writeTimeouts = parent.counter(timeouts, idPrefix.tags("cause", "WriteTimeoutException"));
            this.responseTimeouts = parent.counter(timeouts, idPrefix.tags("cause", "ResponseTimeoutException"));
        }

        @Override
        public Counter actualRequests() {
            if (this.actualRequests != null) {
                return this.actualRequests;
            }
            this.actualRequests = this.parent.counter(this.idPrefix.name("actual.requests"), this.idPrefix.tags());
            return this.actualRequests;
        }

        @Override
        public Timer connectionAcquisitionDuration() {
            return this.connectionAcquisitionDuration;
        }

        @Override
        public Timer dnsResolutionDuration() {
            return this.dnsResolutionDuration;
        }

        @Override
        public Timer socketConnectDuration() {
            return this.socketConnectDuration;
        }

        @Override
        public Timer pendingAcquisitionDuration() {
            return this.pendingAcquisitionDuration;
        }

        @Override
        public Counter writeTimeouts() {
            return this.writeTimeouts;
        }

        @Override
        public Counter responseTimeouts() {
            return this.responseTimeouts;
        }

        @Override
        public DistributionSummary successAttempts() {
            if (this.successAttempts != null) {
                return this.successAttempts;
            }
            this.successAttempts = MoreMeters.newDistributionSummary(this.parent, this.idPrefix.name("actual.requests.attempts"), this.idPrefix.tags("result", "success"));
            return this.successAttempts;
        }

        @Override
        public DistributionSummary failureAttempts() {
            if (this.failureAttempts != null) {
                return this.failureAttempts;
            }
            this.failureAttempts = MoreMeters.newDistributionSummary(this.parent, this.idPrefix.name("actual.requests.attempts"), this.idPrefix.tags("result", "failure"));
            return this.failureAttempts;
        }
    }

    private static abstract class AbstractRequestMetrics
    implements RequestMetrics {
        private final Counter success;
        private final Counter failure;
        private final Timer requestDuration;
        private final DistributionSummary requestLength;
        private final Timer responseDuration;
        private final DistributionSummary responseLength;
        private final Timer totalDuration;

        AbstractRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
            String requests = idPrefix.name("requests");
            this.success = parent.counter(requests, idPrefix.tags("result", "success"));
            this.failure = parent.counter(requests, idPrefix.tags("result", "failure"));
            this.requestDuration = MoreMeters.newTimer(parent, idPrefix.name("request.duration"), idPrefix.tags());
            this.requestLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("request.length"), idPrefix.tags());
            this.responseDuration = MoreMeters.newTimer(parent, idPrefix.name("response.duration"), idPrefix.tags());
            this.responseLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("response.length"), idPrefix.tags());
            this.totalDuration = MoreMeters.newTimer(parent, idPrefix.name("total.duration"), idPrefix.tags());
        }

        @Override
        public Counter success() {
            return this.success;
        }

        @Override
        public Counter failure() {
            return this.failure;
        }

        @Override
        public Timer requestDuration() {
            return this.requestDuration;
        }

        @Override
        public DistributionSummary requestLength() {
            return this.requestLength;
        }

        @Override
        public Timer responseDuration() {
            return this.responseDuration;
        }

        @Override
        public DistributionSummary responseLength() {
            return this.responseLength;
        }

        @Override
        public Timer totalDuration() {
            return this.totalDuration;
        }
    }
}

