/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.client.DnsTimeoutException;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import com.linecorp.armeria.internal.shaded.guava.base.Throwables;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnsUtil {
    private static final List<String> DEFAULT_SEARCH_DOMAINS;
    private static final int DEFAULT_NDOTS;
    public static final int DEFAULT_DNS_QUERY_TIMEOUT_MILLIS = 5000;
    private static final Logger logger;

    public static byte @Nullable [] extractAddressBytes(DnsRecord record, Logger logger, String logPrefix) {
        DnsRecordType type = record.type();
        assert (record instanceof ByteArrayDnsRecord);
        byte[] content = ((ByteArrayDnsRecord)record).content();
        int contentLen = content.length;
        if (type == DnsRecordType.A) {
            if (contentLen != 4) {
                DnsUtil.warnInvalidRecord(logger, logPrefix, type, content);
                return null;
            }
        } else if (type == DnsRecordType.AAAA) {
            if (contentLen != 16) {
                DnsUtil.warnInvalidRecord(logger, logPrefix, type, content);
                return null;
            }
        } else {
            return null;
        }
        return content;
    }

    public static void warnInvalidRecord(Logger logger, String logPrefix, DnsRecordType type, byte[] content) {
        if (logger.isWarnEnabled()) {
            String dump = ByteBufUtil.hexDump(content);
            logger.warn("{} Skipping invalid {} record: {}", logPrefix, type.name(), dump.isEmpty() ? "<empty>" : dump);
        }
    }

    public static List<String> defaultSearchDomains() {
        return DEFAULT_SEARCH_DOMAINS;
    }

    public static int defaultNdots() {
        return DEFAULT_NDOTS;
    }

    public static long defaultDnsQueryTimeoutMillis() {
        return 5000L;
    }

    public static boolean isDnsQueryTimedOut(Throwable cause) {
        Throwable rootCause = Throwables.getRootCause(cause);
        if (rootCause instanceof DnsTimeoutException || rootCause instanceof DnsNameResolverTimeoutException) {
            return true;
        }
        if (rootCause instanceof UnknownHostException) {
            for (Throwable suppressedCause : rootCause.getSuppressed()) {
                Throwable suppressedRootCause = Throwables.getRootCause(suppressedCause);
                if (!(suppressedRootCause instanceof DnsNameResolverTimeoutException)) continue;
                return true;
            }
        }
        return false;
    }

    private DnsUtil() {
    }

    static {
        int ndots;
        ImmutableList<String> defaultSearchDomain;
        logger = LoggerFactory.getLogger(DnsUtil.class);
        EventLoop eventLoop = CommonPools.workerGroup().next();
        DnsNameResolver defaultResolver = new DnsNameResolverBuilder(eventLoop).channelType(TransportType.datagramChannelType(eventLoop.parent())).build();
        try {
            Method searchDomainsMethod = DnsNameResolver.class.getDeclaredMethod("searchDomains", new Class[0]);
            searchDomainsMethod.setAccessible(true);
            String[] searchDomains = (String[])searchDomainsMethod.invoke((Object)defaultResolver, new Object[0]);
            defaultSearchDomain = ImmutableList.copyOf(searchDomains);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Failed to get the default searchDomain value through reflection; search domain resolution is disabled.", e);
            defaultSearchDomain = ImmutableList.of();
        }
        DEFAULT_SEARCH_DOMAINS = defaultSearchDomain;
        try {
            Method ndotsMethod = DnsNameResolver.class.getDeclaredMethod("ndots", new Class[0]);
            ndotsMethod.setAccessible(true);
            ndots = (Integer)ndotsMethod.invoke((Object)defaultResolver, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Failed to get the default ndots value through reflection; using 0 instead.", e);
            ndots = 0;
        }
        DEFAULT_NDOTS = ndots;
    }
}

