/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class DefaultByteStreamMessage
implements ByteStreamMessage {
    private final StreamMessage<? extends HttpData> delegate;
    private long offset;
    private long length = -1L;
    private long demand;
    @Nullable
    private volatile Throwable abortedCause;
    private volatile boolean subscribed;

    DefaultByteStreamMessage(StreamMessage<? extends HttpData> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ByteStreamMessage range(long offset, long length) {
        Preconditions.checkArgument(offset >= 0L, "offset: %s (expected: >= 0)", offset);
        Preconditions.checkArgument(length > 0L, "length: %s (expected: > 0)", length);
        Preconditions.checkState(!this.subscribed, "cannot specify range(%s, %s) after this %s is subscribed", offset, length, DefaultByteStreamMessage.class);
        this.offset = offset;
        this.length = length;
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public long demand() {
        if (this.needsFiltering()) {
            return this.demand;
        }
        return this.delegate.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        this.subscribed = true;
        if (this.needsFiltering()) {
            this.delegate.subscribe((Subscriber<? extends HttpData>)new FilteringSubscriber(subscriber, executor, this.offset, this.length), executor, options);
        } else {
            this.delegate.subscribe(subscriber, executor, options);
        }
    }

    private boolean needsFiltering() {
        return this.offset != 0L || this.length != -1L;
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        if (this.abortedCause != null) {
            return;
        }
        this.abortedCause = cause;
        this.delegate.abort(cause);
    }

    private final class FilteringSubscriber
    implements Subscriber<HttpData>,
    Subscription {
        private final Subscriber<? super HttpData> downstream;
        private final long offset;
        private final long end;
        private final EventExecutor executor;
        @Nullable
        private Subscription upstream;
        private long position;
        private boolean completed;

        FilteringSubscriber(Subscriber<? super HttpData> downstream, EventExecutor executor, long offset, long length) {
            this.downstream = downstream;
            this.executor = executor;
            this.offset = offset;
            this.end = length == -1L ? Long.MAX_VALUE : LongMath.saturatedAdd(offset, length);
        }

        @Override
        public void onSubscribe(Subscription s) {
            Objects.requireNonNull(s, "s");
            this.upstream = s;
            this.downstream.onSubscribe(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(HttpData data) {
            Objects.requireNonNull(data, "data");
            if (this.completed) {
                data.close();
                return;
            }
            if (this.position >= this.end) {
                data.close();
                this.upstream.cancel();
                return;
            }
            int dataSize = data.length();
            long dataEnd = LongMath.saturatedAdd(this.position, dataSize);
            long skipBytes = Math.max(0L, LongMath.saturatedSubtract(this.offset, this.position));
            long dropBytes = Math.max(0L, LongMath.saturatedSubtract(dataEnd, this.end));
            if (skipBytes >= (long)dataSize) {
                data.close();
                this.position += (long)dataSize;
                this.requestOneOrCancel();
                return;
            }
            if (skipBytes == 0L && dropBytes == 0L) {
                this.position += (long)dataSize;
                this.downstream.onNext(data);
            } else {
                try {
                    assert (dropBytes < (long)dataSize);
                    int intSkipBytes = (int)skipBytes;
                    int intDropBytes = (int)dropBytes;
                    int slicedDataSize = dataSize - intSkipBytes - intDropBytes;
                    HttpData slicedData = this.retainedSlice(data, intSkipBytes, slicedDataSize);
                    this.position += (long)(intSkipBytes + slicedDataSize);
                    this.downstream.onNext(slicedData);
                }
                finally {
                    data.close();
                }
            }
            assert (this.position <= this.end);
            if (this.position == this.end) {
                this.onComplete();
                this.upstream.cancel();
            } else if (--DefaultByteStreamMessage.this.demand > 0L) {
                this.upstream.request(1L);
            }
        }

        private void requestOneOrCancel() {
            if (this.position < this.end) {
                this.upstream.request(1L);
            } else {
                this.upstream.cancel();
            }
        }

        private HttpData retainedSlice(HttpData data, int offset, int length) {
            ByteBuf byteBuf = data.byteBuf(offset, length, ByteBufAccessMode.RETAINED_DUPLICATE);
            return HttpData.wrap(byteBuf);
        }

        @Override
        public void onError(Throwable t) {
            Objects.requireNonNull(t, "t");
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (this.executor.inEventLoop()) {
                this.request0(n);
            } else {
                this.executor.execute(() -> this.request0(n));
            }
        }

        private void request0(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
                this.upstream.cancel();
                return;
            }
            if (this.completed) {
                return;
            }
            long oldDemand = DefaultByteStreamMessage.this.demand;
            DefaultByteStreamMessage.this.demand += n;
            if (oldDemand == 0L) {
                this.upstream.request(1L);
            }
        }

        @Override
        public void cancel() {
            if (this.executor.inEventLoop()) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
        }

        private void cancel0() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.upstream.cancel();
        }
    }
}

