/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;

public enum LogLevel {
    OFF,
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public boolean isEnabled(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        switch (this) {
            case OFF: {
                return false;
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        throw new Error();
    }

    public void log(Logger logger, String message) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(message, "message");
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        if (arg1 instanceof Throwable) {
            this.log(logger, format, (Throwable)arg1);
            return;
        }
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(format, arg1);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1);
                break;
            }
            case INFO: {
                logger.info(format, arg1);
                break;
            }
            case WARN: {
                logger.warn(format, arg1);
                break;
            }
            case ERROR: {
                logger.error(format, arg1);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void log(Logger logger, String format, Throwable throwable) {
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(format, throwable);
                break;
            }
            case DEBUG: {
                logger.debug(format, throwable);
                break;
            }
            case INFO: {
                logger.info(format, throwable);
                break;
            }
            case WARN: {
                logger.warn(format, throwable);
                break;
            }
            case ERROR: {
                logger.error(format, throwable);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1, @Nullable Object arg2) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(format, arg1, arg2);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1, arg2);
                break;
            }
            case INFO: {
                logger.info(format, arg1, arg2);
                break;
            }
            case WARN: {
                logger.warn(format, arg1, arg2);
                break;
            }
            case ERROR: {
                logger.error(format, arg1, arg2);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(format, arg1, arg2, arg3);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1, arg2, arg3);
                break;
            }
            case INFO: {
                logger.info(format, arg1, arg2, arg3);
                break;
            }
            case WARN: {
                logger.warn(format, arg1, arg2, arg3);
                break;
            }
            case ERROR: {
                logger.error(format, arg1, arg2, arg3);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, Object ... args) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this) {
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace(format, args);
                break;
            }
            case DEBUG: {
                logger.debug(format, args);
                break;
            }
            case INFO: {
                logger.info(format, args);
                break;
            }
            case WARN: {
                logger.warn(format, args);
                break;
            }
            case ERROR: {
                logger.error(format, args);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

