/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.io.BaseEncoding;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSession;

public enum BuiltInProperty {
    REMOTE_HOST("remote.host", log -> {
        InetSocketAddress addr = log.context().remoteAddress();
        return addr != null ? addr.getHostString() : null;
    }),
    REMOTE_IP("remote.ip", log -> {
        InetSocketAddress addr = log.context().remoteAddress();
        return addr != null ? addr.getAddress().getHostAddress() : null;
    }),
    REMOTE_PORT("remote.port", log -> {
        InetSocketAddress addr = log.context().remoteAddress();
        return addr != null ? StringUtil.toString(addr.getPort()) : null;
    }),
    LOCAL_HOST("local.host", log -> {
        InetSocketAddress addr = log.context().localAddress();
        return addr != null ? addr.getHostString() : null;
    }),
    LOCAL_IP("local.ip", log -> {
        InetSocketAddress addr = log.context().localAddress();
        return addr != null ? addr.getAddress().getHostAddress() : null;
    }),
    LOCAL_PORT("local.port", log -> {
        InetSocketAddress addr = log.context().localAddress();
        return addr != null ? StringUtil.toString(addr.getPort()) : null;
    }),
    CLIENT_IP("client.ip", log -> {
        RequestContext ctx = log.context();
        InetAddress caddr = ctx instanceof ServiceRequestContext ? ((ServiceRequestContext)ctx).clientAddress() : null;
        return caddr != null ? caddr.getHostAddress() : null;
    }),
    SCHEME("scheme", log -> {
        if (log.isAvailable(RequestLogProperty.SCHEME)) {
            return log.scheme().uriText();
        }
        return "unknown+" + log.context().sessionProtocol().uriText();
    }),
    ELAPSED_NANOS("elapsed_nanos", log -> {
        if (log.isAvailable(RequestLogProperty.RESPONSE_END_TIME)) {
            return String.valueOf(log.totalDurationNanos());
        }
        return null;
    }),
    REQ_DIRECTION("req.direction", log -> {
        RequestContext ctx = log.context();
        if (ctx instanceof ServiceRequestContext) {
            return "INBOUND";
        }
        if (ctx instanceof ClientRequestContext) {
            return "OUTBOUND";
        }
        return "UNKNOWN";
    }),
    REQ_AUTHORITY("req.authority", BuiltInProperty::getAuthority),
    REQ_ID("req.id", log -> log.context().id().text()),
    REQ_ROOT_ID("req.root_id", log -> {
        ServiceRequestContext rootCtx = log.context().root();
        return rootCtx != null ? rootCtx.id().text() : null;
    }),
    REQ_PATH("req.path", log -> log.context().path()),
    REQ_QUERY("req.query", log -> log.context().query()),
    REQ_METHOD("req.method", log -> log.context().method().name()),
    REQ_NAME("req.name", log -> log.isAvailable(RequestLogProperty.NAME) ? log.name() : null),
    REQ_SERVICE_NAME("req.service_name", log -> log.isAvailable(RequestLogProperty.NAME) ? log.serviceName() : null),
    REQ_CONTENT_LENGTH("req.content_length", log -> {
        if (log.isAvailable(RequestLogProperty.REQUEST_LENGTH)) {
            return StringUtil.toString(log.requestLength());
        }
        return null;
    }),
    REQ_CONTENT("req.content", log -> {
        Object requestContent;
        if (log.isAvailable(RequestLogProperty.REQUEST_CONTENT) && (requestContent = log.requestContent()) instanceof RpcRequest) {
            return String.valueOf(((RpcRequest)requestContent).params());
        }
        if (log.isAvailable(RequestLogProperty.REQUEST_CONTENT_PREVIEW)) {
            return log.requestContentPreview();
        }
        return null;
    }),
    REQ_CAUSE("req.cause", log -> {
        Throwable requestCause;
        if (log.isAvailable(RequestLogProperty.REQUEST_CAUSE) && (requestCause = log.requestCause()) != null) {
            return Exceptions.traceText(requestCause);
        }
        return null;
    }),
    RES_STATUS_CODE("res.status_code", log -> {
        if (log.isAvailable(RequestLogProperty.RESPONSE_HEADERS)) {
            return log.responseHeaders().status().codeAsText();
        }
        return null;
    }),
    RES_CONTENT_LENGTH("res.content_length", log -> {
        if (log.isAvailable(RequestLogProperty.RESPONSE_LENGTH)) {
            return StringUtil.toString(log.responseLength());
        }
        return null;
    }),
    RES_CONTENT("res.content", log -> {
        RpcResponse rpcRes;
        Object responseContent;
        if (log.isAvailable(RequestLogProperty.RESPONSE_CONTENT) && (responseContent = log.responseContent()) instanceof RpcResponse && !(rpcRes = (RpcResponse)responseContent).isCompletedExceptionally()) {
            return String.valueOf(rpcRes.join());
        }
        if (log.isAvailable(RequestLogProperty.RESPONSE_CONTENT_PREVIEW)) {
            return log.responseContentPreview();
        }
        return null;
    }),
    RES_CAUSE("res.cause", log -> {
        Throwable responseCause;
        if (log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) && (responseCause = log.responseCause()) != null) {
            return Exceptions.traceText(responseCause);
        }
        return null;
    }),
    TLS_SESSION_ID("tls.session_id", log -> {
        byte[] id;
        SSLSession s = log.context().sslSession();
        if (s != null && (id = s.getId()) != null) {
            return BuiltInProperty.lowerCasedBase16().encode(id);
        }
        return null;
    }),
    TLS_CIPHER("tls.cipher", log -> {
        SSLSession s = log.context().sslSession();
        return s != null ? s.getCipherSuite() : null;
    }),
    TLS_PROTO("tls.proto", log -> {
        SSLSession s = log.context().sslSession();
        return s != null ? s.getProtocol() : null;
    });

    private static final Map<String, BuiltInProperty> keyToEnum;
    static final String WILDCARD_STR = "*";
    static final String WILDCARD_REGEX = "\\*";
    private static final Pattern PORT_443;
    private static final Pattern PORT_80;
    private static final BaseEncoding lowerCasedBase16;
    final String key;
    final Function<? super RequestLog, String> converter;

    static List<BuiltInProperty> findByKeyPattern(String keyPattern) {
        Pattern pattern = Pattern.compile(("\\Q" + keyPattern + "\\E").replaceAll(WILDCARD_REGEX, "\\\\E.*\\\\Q"));
        return keyToEnum.entrySet().stream().filter(e -> pattern.matcher((CharSequence)e.getKey()).matches()).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    static BuiltInProperty findByKey(String key) {
        return keyToEnum.entrySet().stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static BaseEncoding lowerCasedBase16() {
        return lowerCasedBase16;
    }

    private static String getAuthority(RequestLog log) {
        String authority;
        String authority2;
        RequestContext ctx = log.context();
        if (log.isAvailable(RequestLogProperty.REQUEST_HEADERS) && (authority2 = BuiltInProperty.getAuthority0(ctx, log.requestHeaders())) != null) {
            return authority2;
        }
        HttpRequest origReq = ctx.request();
        if (origReq != null && (authority = BuiltInProperty.getAuthority0(ctx, origReq.headers())) != null) {
            return authority;
        }
        if (ctx instanceof ServiceRequestContext) {
            ServiceRequestContext sCtx = (ServiceRequestContext)ctx;
            int port = sCtx.remoteAddress().getPort();
            String hostname = sCtx.config().virtualHost().defaultHostname();
            authority = port == ctx.sessionProtocol().defaultPort() ? hostname : hostname + ':' + port;
        } else {
            int defaultPort;
            int port;
            ClientRequestContext cCtx = (ClientRequestContext)ctx;
            Endpoint endpoint = cCtx.endpoint();
            authority = endpoint == null ? "UNKNOWN" : ((port = endpoint.port(defaultPort = cCtx.sessionProtocol().defaultPort())) == defaultPort ? endpoint.host() : endpoint.host() + ':' + port);
        }
        return authority;
    }

    @Nullable
    private static String getAuthority0(RequestContext ctx, HttpHeaders headers) {
        String authority = headers.get(HttpHeaderNames.AUTHORITY);
        if (authority != null) {
            Pattern portPattern = ctx.sessionProtocol().isTls() ? PORT_443 : PORT_80;
            Matcher m = portPattern.matcher(authority);
            if (m.find()) {
                authority = authority.substring(0, m.start());
            }
            return authority;
        }
        return null;
    }

    private BuiltInProperty(String key, Function<? super RequestLog, String> converter) {
        this.key = key;
        this.converter = converter;
    }

    static {
        PORT_443 = Pattern.compile(":0*443$");
        PORT_80 = Pattern.compile(":0*80$");
        lowerCasedBase16 = BaseEncoding.base16().lowerCase();
        ImmutableMap.Builder<String, BuiltInProperty> builder = ImmutableMap.builder();
        for (BuiltInProperty k : BuiltInProperty.values()) {
            builder.put(k.key, k);
        }
        keyToEnum = builder.build();
    }
}

