/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DeferredHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class HttpResponseUtil {
    static HttpResponse createHttpResponseFrom(CompletableFuture<? extends HttpResponse> future) {
        Objects.requireNonNull(future, "future");
        if (future.isDone()) {
            if (!future.isCompletedExceptionally()) {
                return future.getNow(null);
            }
            try {
                future.join();
                throw new Error();
            }
            catch (Throwable cause) {
                return HttpResponse.ofFailure(Exceptions.peel(cause));
            }
        }
        DeferredHttpResponse res = new DeferredHttpResponse();
        res.delegateWhenComplete(future);
        return res;
    }

    private HttpResponseUtil() {
    }
}

