/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerListener;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMetrics;
import com.linecorp.armeria.client.circuitbreaker.CircuitState;
import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;

final class MetricCollectingCircuitBreakerListener
implements CircuitBreakerListener {
    private final MeterRegistry registry;
    private final String name;

    MetricCollectingCircuitBreakerListener(MeterRegistry registry, String name) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public void onStateChanged(String circuitBreakerName, CircuitState state) {
        this.metricsOf(circuitBreakerName).onStateChanged(state);
    }

    @Override
    public void onEventCountUpdated(String circuitBreakerName, EventCount eventCount) {
        this.metricsOf(circuitBreakerName).onCountUpdated(eventCount);
    }

    @Override
    public void onRequestRejected(String circuitBreakerName) {
        this.metricsOf(circuitBreakerName).onRequestRejected();
    }

    private CircuitBreakerMetrics metricsOf(String circuitBreakerName) {
        MeterIdPrefix idPrefix = new MeterIdPrefix(this.name, "name", circuitBreakerName);
        return MicrometerUtil.register(this.registry, idPrefix, CircuitBreakerMetrics.class, CircuitBreakerMetrics::new);
    }
}

