/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpRequestSubscriber;
import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;

class HttpRequestSubscriber
extends AbstractHttpRequestSubscriber {
    HttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis) {
        super(ch, encoder, responseDecoder, request, originalRes, ctx, timeoutMillis, true, true);
    }

    @Override
    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            this.failAndReset(new IllegalArgumentException("published an HttpObject that's neither Http2Headers nor Http2Data: " + o));
            PooledObjects.close(o);
            return;
        }
        switch (this.state()) {
            case NEEDS_DATA_OR_TRAILERS: {
                if (o instanceof HttpHeaders) {
                    HttpHeaders trailers = (HttpHeaders)o;
                    if (trailers.contains(HttpHeaderNames.STATUS)) {
                        this.failAndReset(new IllegalArgumentException("published a trailers with status: " + o));
                        return;
                    }
                    this.writeTrailers(trailers);
                } else {
                    this.writeData((HttpData)o);
                }
                this.channel().flush();
                break;
            }
            case DONE: {
                this.cancel();
                PooledObjects.close(o);
            }
        }
    }
}

