/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractEventLoopEntry;
import com.linecorp.armeria.client.AbstractEventLoopState;
import com.linecorp.armeria.client.DefaultEventLoopScheduler;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import io.netty.channel.EventLoop;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

final class HeapBasedEventLoopState
extends AbstractEventLoopState {
    private final List<AbstractEventLoopEntry> entries = new ArrayList<AbstractEventLoopEntry>();
    private final int maxNumEventLoops;
    private int acquisitionStartIndex = -1;
    private int nextUnusedEventLoopOffset;
    private int allActiveRequests;

    HeapBasedEventLoopState(List<EventLoop> eventLoops, int maxNumEventLoops, DefaultEventLoopScheduler scheduler) {
        super(eventLoops, scheduler);
        this.maxNumEventLoops = maxNumEventLoops;
        if (eventLoops.size() == maxNumEventLoops) {
            this.init(0);
        }
    }

    private void init(int acquisitionStartIndex) {
        this.acquisitionStartIndex = acquisitionStartIndex;
        this.nextUnusedEventLoopOffset = ThreadLocalRandom.current().nextInt(this.maxNumEventLoops);
        this.addUnusedEventLoop();
    }

    private boolean addUnusedEventLoop() {
        if (this.entries.size() < this.maxNumEventLoops) {
            int nextIndex = (this.acquisitionStartIndex + this.nextUnusedEventLoopOffset) % this.eventLoops().size();
            this.push(new Entry(this, this.eventLoops().get(nextIndex), this.entries.size()));
            this.nextUnusedEventLoopOffset = (this.nextUnusedEventLoopOffset + 1) % this.maxNumEventLoops;
            return true;
        }
        return false;
    }

    @Override
    List<AbstractEventLoopEntry> entries() {
        return this.entries;
    }

    @Override
    int allActiveRequests() {
        return this.allActiveRequests;
    }

    @Override
    AbstractEventLoopEntry acquire() {
        this.lock();
        try {
            AbstractEventLoopEntry e;
            if (this.acquisitionStartIndex == -1) {
                this.init(this.scheduler().acquisitionStartIndex(this.maxNumEventLoops));
            }
            if ((e = this.entries.get(0)).activeRequests() > 0 && this.addUnusedEventLoop()) {
                e = this.entries.get(0);
                assert (e.activeRequests() == 0);
            }
            assert (e.index() == 0);
            e.incrementActiveRequests();
            ++this.allActiveRequests;
            this.bubbleDown();
            AbstractEventLoopEntry abstractEventLoopEntry = e;
            return abstractEventLoopEntry;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    void release(AbstractEventLoopEntry e) {
        this.lock();
        try {
            e.decrementActiveRequests();
            this.bubbleUp(e.index());
            if (--this.allActiveRequests == 0) {
                this.setLastActivityTimeNanos();
            }
        }
        finally {
            this.unlock();
        }
    }

    private void push(Entry e) {
        this.entries.add(e);
        this.bubbleUp(this.entries.size() - 1);
    }

    private void bubbleDown() {
        int best = 0;
        while (true) {
            int oldBest = best;
            int left = HeapBasedEventLoopState.left(best);
            if (left >= this.entries.size()) break;
            int right = HeapBasedEventLoopState.right(best);
            if (this.isBetter(left, best)) {
                best = right < this.entries.size() ? (this.isBetter(right, left) ? right : left) : left;
            } else {
                if (right >= this.entries.size() || !this.isBetter(right, best)) break;
                best = right;
            }
            this.swap(best, oldBest);
        }
    }

    private void bubbleUp(int i) {
        int parent;
        while (i > 0 && !this.isBetter(parent = HeapBasedEventLoopState.parent(i), i)) {
            this.swap(parent, i);
            i = parent;
        }
    }

    private boolean isBetter(int a, int b) {
        AbstractEventLoopEntry entryA = this.entries.get(a);
        AbstractEventLoopEntry entryB = this.entries.get(b);
        if (entryA.activeRequests() < entryB.activeRequests()) {
            return true;
        }
        if (entryA.activeRequests() > entryB.activeRequests()) {
            return false;
        }
        return entryA.id() < entryB.id();
    }

    private static int parent(int i) {
        return (i - 1) / 2;
    }

    private static int left(int i) {
        return 2 * i + 1;
    }

    private static int right(int i) {
        return 2 * i + 2;
    }

    private void swap(int i, int j) {
        AbstractEventLoopEntry entryI = this.entries.get(i);
        AbstractEventLoopEntry entryJ = this.entries.get(j);
        this.entries.set(i, entryJ);
        this.entries.set(j, entryI);
        entryJ.setIndex(i);
        entryI.setIndex(j);
    }

    public String toString() {
        return '[' + Joiner.on(", ").join(this.entries) + ']';
    }

    private static final class Entry
    extends AbstractEventLoopEntry {
        private final int id;
        private int index;
        private int activeRequests;

        Entry(AbstractEventLoopState parent, EventLoop eventLoop, int id) {
            super(parent, eventLoop);
            this.id = this.index = id;
        }

        @Override
        int activeRequests() {
            return this.activeRequests;
        }

        @Override
        void incrementActiveRequests() {
            ++this.activeRequests;
        }

        @Override
        void decrementActiveRequests() {
            --this.activeRequests;
        }

        @Override
        int id() {
            return this.id;
        }

        @Override
        int index() {
            return this.index;
        }

        @Override
        void setIndex(int index) {
            this.index = index;
        }

        public String toString() {
            return "(" + this.index + ", " + this.id + ", " + this.activeRequests() + ')';
        }
    }
}

