/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpRequestHandler;
import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpRequestSubscriber;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.WebSocketHttp1RequestSubscriber;
import com.linecorp.armeria.client.WebSocketHttp2RequestSubscriber;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import io.netty.channel.Channel;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractHttpRequestSubscriber
extends AbstractHttpRequestHandler
implements Subscriber<HttpObject> {
    private static final HttpData EMPTY_EOS = HttpData.empty().withEndOfStream();
    private final HttpRequest request;
    @Nullable
    private Subscription subscription;
    private boolean isSubscriptionCompleted;

    static AbstractHttpRequestSubscriber of(Channel channel, ClientHttpObjectEncoder requestEncoder, HttpResponseDecoder responseDecoder, SessionProtocol protocol, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res, long writeTimeoutMillis, boolean webSocket) {
        if (webSocket) {
            if (protocol.isExplicitHttp1()) {
                return new WebSocketHttp1RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
            }
            assert (protocol.isExplicitHttp2());
            return new WebSocketHttp2RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
        }
        return new HttpRequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
    }

    AbstractHttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis, boolean allowTrailers, boolean keepAlive) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty(), allowTrailers, keepAlive);
        this.request = request;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state() == AbstractHttpRequestHandler.State.DONE) {
            this.cancel();
            return;
        }
        if (!this.tryInitialize()) {
            return;
        }
        this.writeHeaders(this.mapHeaders(this.request.headers()));
        this.channel().flush();
    }

    RequestHeaders mapHeaders(RequestHeaders headers) {
        return headers;
    }

    @Override
    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        this.failRequest(cause);
    }

    @Override
    public void onComplete() {
        this.isSubscriptionCompleted = true;
        if (this.state() != AbstractHttpRequestHandler.State.DONE) {
            this.writeData(EMPTY_EOS);
            this.channel().flush();
        }
    }

    @Override
    void onWriteSuccess() {
        if (!this.isSubscriptionCompleted) {
            assert (this.subscription != null);
            this.subscription.request(1L);
        }
    }

    @Override
    void cancel() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }
}

