/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.server.ServiceRequestContext;
import graphql.GraphQLContext;
import graphql.VisibleForTesting;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.Objects;

public final class GraphqlServiceContexts {
    @VisibleForTesting
    static final String GRAPHQL_CONTEXT_KEY = "com.linecorp.armeria.graphql.context.key";

    static Map<String, Object> graphqlContext(ServiceRequestContext requestContext) {
        Objects.requireNonNull(requestContext, "requestContext");
        return ImmutableMap.of((Object)GRAPHQL_CONTEXT_KEY, (Object)requestContext);
    }

    public static ServiceRequestContext get(GraphQLContext graphQLContext) {
        Objects.requireNonNull(graphQLContext, "graphQLContext");
        ServiceRequestContext ctx = (ServiceRequestContext)graphQLContext.get((Object)GRAPHQL_CONTEXT_KEY);
        if (ctx == null) {
            throw new IllegalStateException("missing request context");
        }
        return ctx;
    }

    public static ServiceRequestContext get(DataFetchingEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        return GraphqlServiceContexts.get(environment.getGraphQlContext());
    }

    private GraphqlServiceContexts() {
    }
}

