/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ResourceUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.DefaultGraphqlService;
import com.linecorp.armeria.server.graphql.ExecutionIdGenerator;
import com.linecorp.armeria.server.graphql.GraphqlConfigurator;
import com.linecorp.armeria.server.graphql.GraphqlErrorHandler;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.RuntimeWiringConfigurator;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphqlServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlServiceBuilder.class);
    private static final List<String> DEFAULT_SCHEMA_FILE_NAMES = ImmutableList.of((Object)"schema.graphqls", (Object)"schema.graphql");
    private final ImmutableList.Builder<URL> schemaUrls = ImmutableList.builder();
    private final ImmutableList.Builder<RuntimeWiringConfigurator> runtimeWiringConfigurators = ImmutableList.builder();
    private final ImmutableList.Builder<GraphQLTypeVisitor> typeVisitors = ImmutableList.builder();
    private final ImmutableList.Builder<Instrumentation> instrumentations = ImmutableList.builder();
    private final ImmutableList.Builder<GraphqlConfigurator> graphqlBuilderConsumers = ImmutableList.builder();
    @Nullable
    private ImmutableList.Builder<Consumer<? super DataLoaderRegistry>> dataLoaderRegistryConsumers;
    private boolean useBlockingTaskExecutor;
    @Nullable
    private Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory;
    @Nullable
    private GraphQLSchema schema;
    @Nullable
    private GraphqlErrorHandler errorHandler;
    private ExecutionIdGenerator executionIdGenerator = ExecutionIdGenerator.of();

    GraphqlServiceBuilder() {
    }

    public GraphqlServiceBuilder schemaFile(File ... schemaFiles) {
        return this.schemaFile((Iterable<? extends File>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaFiles, "schemaFiles")));
    }

    public GraphqlServiceBuilder schemaFile(Iterable<? extends File> schemaFiles) {
        Objects.requireNonNull(schemaFiles, "schemaFiles");
        return this.schemaUrls0((Iterable)Streams.stream(schemaFiles).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    public GraphqlServiceBuilder schemaUrls(String ... schemaUrls) {
        return this.schemaUrls((Iterable<String>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaUrls, "schemaUrls")));
    }

    public GraphqlServiceBuilder schemaUrls(Iterable<String> schemaUrls) {
        Objects.requireNonNull(schemaUrls, "schemaUrls");
        return this.schemaUrls0((Iterable)Streams.stream(schemaUrls).map(url -> {
            try {
                return ResourceUtil.getUrl((String)url);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Not found schema file(s)", e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    private GraphqlServiceBuilder schemaUrls0(Iterable<URL> schemaUrls) {
        this.schemaUrls.addAll(Objects.requireNonNull(schemaUrls, "schemaUrls"));
        return this;
    }

    public GraphqlServiceBuilder schema(GraphQLSchema schema) {
        this.schema = Objects.requireNonNull(schema, "schema");
        return this;
    }

    public GraphqlServiceBuilder dataLoaderRegistry(Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory) {
        Preconditions.checkState((this.dataLoaderRegistryConsumers == null ? 1 : 0) != 0, (Object)"configureDataLoaderRegistry() and dataLoaderRegistry() are mutually exclusive.");
        this.dataLoaderRegistryFactory = Objects.requireNonNull(dataLoaderRegistryFactory, "dataLoaderRegistryFactory");
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder configureDataLoaderRegistry(Consumer<DataLoaderRegistry> ... configurers) {
        Objects.requireNonNull(configurers, "configurers");
        return this.configureDataLoaderRegistry((Iterable<? extends Consumer<? super DataLoaderRegistry>>)ImmutableList.copyOf((Object[])configurers));
    }

    @Deprecated
    public GraphqlServiceBuilder configureDataLoaderRegistry(Iterable<? extends Consumer<? super DataLoaderRegistry>> configurers) {
        Preconditions.checkState((this.dataLoaderRegistryFactory == null ? 1 : 0) != 0, (Object)"configureDataLoaderRegistry() and dataLoaderRegistry() are mutually exclusive.");
        if (this.dataLoaderRegistryConsumers == null) {
            this.dataLoaderRegistryConsumers = ImmutableList.builder();
        }
        this.dataLoaderRegistryConsumers.addAll(Objects.requireNonNull(configurers, "configurers"));
        return this;
    }

    public GraphqlServiceBuilder runtimeWiring(RuntimeWiringConfigurator ... runtimeWiringConfigurators) {
        Objects.requireNonNull(runtimeWiringConfigurators, "runtimeWiringConfigurators");
        return this.runtimeWiring((Iterable<? extends RuntimeWiringConfigurator>)ImmutableList.copyOf((Object[])runtimeWiringConfigurators));
    }

    public GraphqlServiceBuilder runtimeWiring(Iterable<? extends RuntimeWiringConfigurator> configurators) {
        this.runtimeWiringConfigurators.addAll(Objects.requireNonNull(configurators, "configurators"));
        return this;
    }

    public GraphqlServiceBuilder typeVisitors(GraphQLTypeVisitor ... typeVisitors) {
        return this.typeVisitors((Iterable<? extends GraphQLTypeVisitor>)ImmutableList.copyOf((Object[])Objects.requireNonNull(typeVisitors, "typeVisitors")));
    }

    public GraphqlServiceBuilder typeVisitors(Iterable<? extends GraphQLTypeVisitor> typeVisitors) {
        this.typeVisitors.addAll(Objects.requireNonNull(typeVisitors, "typeVisitors"));
        return this;
    }

    public GraphqlServiceBuilder instrumentation(Instrumentation ... instrumentations) {
        Objects.requireNonNull(instrumentations, "instrumentations");
        return this.instrumentation((Iterable<? extends Instrumentation>)ImmutableList.copyOf((Object[])instrumentations));
    }

    public GraphqlServiceBuilder instrumentation(Iterable<? extends Instrumentation> instrumentations) {
        this.instrumentations.addAll(Objects.requireNonNull(instrumentations, "instrumentations"));
        return this;
    }

    public GraphqlServiceBuilder configureGraphql(GraphqlConfigurator ... configurers) {
        return this.configureGraphql((Iterable<? extends GraphqlConfigurator>)ImmutableList.copyOf((Object[])Objects.requireNonNull(configurers, "configurers")));
    }

    public GraphqlServiceBuilder configureGraphql(Iterable<? extends GraphqlConfigurator> configurers) {
        this.graphqlBuilderConsumers.addAll(Objects.requireNonNull(configurers, "configurers"));
        return this;
    }

    public GraphqlServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GraphqlServiceBuilder errorHandler(GraphqlErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        return this;
    }

    public GraphqlServiceBuilder executionIdGenerator(ExecutionIdGenerator executionIdGenerator) {
        this.executionIdGenerator = Objects.requireNonNull(executionIdGenerator, "executionIdGenerator");
        return this;
    }

    public GraphqlService build() {
        GraphQLSchema schema = this.buildSchema();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema).executionIdProvider(this.executionIdGenerator.asExecutionProvider());
        ImmutableList instrumentations = this.instrumentations.build();
        if (!instrumentations.isEmpty()) {
            builder = builder.instrumentation((Instrumentation)new ChainedInstrumentation((List)instrumentations));
        }
        ImmutableList graphqlBuilders = this.graphqlBuilderConsumers.build();
        for (GraphqlConfigurator configurer : graphqlBuilders) {
            configurer.configure(builder);
        }
        Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory = null;
        if (this.dataLoaderRegistryFactory != null) {
            dataLoaderRegistryFactory = this.dataLoaderRegistryFactory;
        } else if (this.dataLoaderRegistryConsumers != null) {
            DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
            for (Consumer configurer : this.dataLoaderRegistryConsumers.build()) {
                configurer.accept(dataLoaderRegistry);
            }
            dataLoaderRegistryFactory = ctx -> dataLoaderRegistry;
        } else {
            assert (dataLoaderRegistryFactory == null && this.dataLoaderRegistryConsumers == null);
            dataLoaderRegistryFactory = ctx -> new DataLoaderRegistry();
        }
        GraphqlErrorHandler errorHandler = this.errorHandler == null ? GraphqlErrorHandler.of() : this.errorHandler.orElse(GraphqlErrorHandler.of());
        return new DefaultGraphqlService(builder.build(), dataLoaderRegistryFactory, this.useBlockingTaskExecutor, errorHandler);
    }

    private GraphQLSchema buildSchema() {
        ImmutableList schemaUrls = this.schemaUrls.build();
        ImmutableList runtimeWiringConfigurators = this.runtimeWiringConfigurators.build();
        ImmutableList typeVisitors = this.typeVisitors.build();
        if (this.schema != null) {
            Preconditions.checkState((schemaUrls.isEmpty() && runtimeWiringConfigurators.isEmpty() && typeVisitors.isEmpty() ? 1 : 0) != 0, (Object)"Cannot add schemaUrl(or File), runtimeWiringConfigurator and typeVisitor when GraphqlSchema is specified.");
            return this.schema;
        }
        TypeDefinitionRegistry registry = GraphqlServiceBuilder.typeDefinitionRegistry((List<URL>)schemaUrls);
        RuntimeWiring runtimeWiring = GraphqlServiceBuilder.buildRuntimeWiring((List<RuntimeWiringConfigurator>)runtimeWiringConfigurators);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(registry, runtimeWiring);
        for (GraphQLTypeVisitor typeVisitor : typeVisitors) {
            schema = SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)typeVisitor);
        }
        return schema;
    }

    private static TypeDefinitionRegistry typeDefinitionRegistry(List<URL> schemaUrls) {
        TypeDefinitionRegistry registry = new TypeDefinitionRegistry();
        SchemaParser parser = new SchemaParser();
        if (schemaUrls.isEmpty()) {
            schemaUrls = GraphqlServiceBuilder.defaultSchemaUrls();
        }
        if (schemaUrls.isEmpty()) {
            throw new IllegalStateException("Not found schema file(s)");
        }
        logger.info("Found schema files: {}", schemaUrls);
        schemaUrls.forEach(url -> {
            try (InputStream inputStream = url.openStream();){
                registry.merge(parser.parse(inputStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return registry;
    }

    private static RuntimeWiring buildRuntimeWiring(List<RuntimeWiringConfigurator> runtimeWiringConfigurators) {
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        runtimeWiringConfigurators.forEach(it -> it.configure(runtimeWiringBuilder));
        return runtimeWiringBuilder.build();
    }

    private static List<URL> defaultSchemaUrls() {
        ClassLoader classLoader = GraphqlServiceBuilder.class.getClassLoader();
        return (List)DEFAULT_SCHEMA_FILE_NAMES.stream().map(classLoader::getResource).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }
}

