/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.mqe.rt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.MQEVisitorBase;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.mqe.rt.type.Metadata;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.RecordsQuery;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQEVisitor
extends MQEVisitorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQEVisitor.class);
    private final MetricsQuery metricsQuery;
    private final RecordsQuery recordsQuery;
    private final Entity entity;
    private final Duration duration;

    public MQEVisitor(MetricsQuery metricsQuery, RecordsQuery recordsQuery, Entity entity, Duration duration) {
        this.metricsQuery = metricsQuery;
        this.recordsQuery = recordsQuery;
        this.entity = entity;
        this.duration = duration;
    }

    public ExpressionResult visitMetric(MQEParser.MetricContext ctx) {
        ExpressionResult result;
        block10: {
            result = new ExpressionResult();
            String metricName = ctx.metricName().getText();
            Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
            if (valueColumn.isEmpty()) {
                result.setType(ExpressionResultType.UNKNOWN);
                result.setError("Metric: [" + metricName + "] dose not exist.");
                return result;
            }
            Column.ValueDataType dataType = ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType();
            try {
                if (Column.ValueDataType.COMMON_VALUE == dataType) {
                    if (ctx.parent instanceof MQEParser.TopNOPContext) {
                        MQEParser.TopNOPContext parent = (MQEParser.TopNOPContext)ctx.parent;
                        this.querySortMetrics(metricName, Integer.parseInt(parent.parameter().getText()), Order.valueOf((String)parent.order().getText().toUpperCase()), result);
                    } else {
                        this.queryMetrics(metricName, result);
                    }
                    break block10;
                }
                if (Column.ValueDataType.LABELED_VALUE == dataType) {
                    String labelValue;
                    String labelValueTrim;
                    List<String> queryLabelList = Collections.emptyList();
                    if (ctx.label() != null && StringUtil.isNotBlank((String)(labelValueTrim = (labelValue = ctx.label().labelValue().getText()).substring(1, labelValue.length() - 1)))) {
                        queryLabelList = Arrays.asList(labelValueTrim.split(","));
                    }
                    this.queryLabeledMetrics(metricName, queryLabelList, result);
                    break block10;
                }
                if (Column.ValueDataType.SAMPLED_RECORD != dataType) break block10;
                if (ctx.parent instanceof MQEParser.TopNOPContext) {
                    MQEParser.TopNOPContext parent = (MQEParser.TopNOPContext)ctx.parent;
                    this.queryRecords(metricName, Integer.parseInt(parent.parameter().getText()), Order.valueOf((String)parent.order().getText().toUpperCase()), result);
                    break block10;
                }
                throw new IllegalExpressionException("Metric: [" + metricName + "] is topN record, need top_n function for query.");
            }
            catch (IllegalExpressionException e) {
                ExpressionResult errorResult = new ExpressionResult();
                errorResult.setType(ExpressionResultType.UNKNOWN);
                errorResult.setError(e.getMessage());
                return errorResult;
            }
            catch (IOException e) {
                ExpressionResult errorResult = new ExpressionResult();
                errorResult.setType(ExpressionResultType.UNKNOWN);
                errorResult.setError("Internal IO exception, query metrics error.");
                log.error("Query metrics from backend error.", (Throwable)e);
                return errorResult;
            }
        }
        return result;
    }

    private void querySortMetrics(String metricName, int topN, Order order, ExpressionResult result) throws IOException {
        TopNCondition topNCondition = new TopNCondition();
        topNCondition.setName(metricName);
        topNCondition.setTopN(topN);
        topNCondition.setParentService(this.entity.getServiceName());
        topNCondition.setOrder(order);
        topNCondition.setNormal(this.entity.getNormal().booleanValue());
        List<SelectedRecord> selectedRecords = this.metricsQuery.sortMetrics(topNCondition, this.duration);
        ArrayList mqeValueList = new ArrayList(selectedRecords.size());
        selectedRecords.forEach(selectedRecord -> {
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(selectedRecord.getName());
            mqeValue.setEmptyValue(false);
            mqeValue.setDoubleValue(Double.parseDouble(selectedRecord.getValue()));
            mqeValueList.add(mqeValue);
        });
        Metadata metadata = new Metadata();
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        mqeValues.setMetric(metadata);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.SORTED_LIST);
    }

    private void queryRecords(String metricName, int topN, Order order, ExpressionResult result) throws IOException {
        RecordCondition recordCondition = new RecordCondition();
        recordCondition.setName(metricName);
        recordCondition.setTopN(topN);
        recordCondition.setParentEntity(this.entity);
        recordCondition.setOrder(order);
        List<Record> records = this.recordsQuery.readRecords(recordCondition, this.duration);
        ArrayList mqeValueList = new ArrayList(records.size());
        records.forEach(record -> {
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(record.getName());
            mqeValue.setEmptyValue(false);
            mqeValue.setDoubleValue(Double.parseDouble(record.getValue()));
            mqeValue.setTraceID(record.getRefId());
            mqeValueList.add(mqeValue);
        });
        Metadata metadata = new Metadata();
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        mqeValues.setMetric(metadata);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.RECORD_LIST);
    }

    private void queryMetrics(String metricName, ExpressionResult result) throws IOException {
        MetricsCondition metricsCondition = new MetricsCondition();
        metricsCondition.setName(metricName);
        metricsCondition.setEntity(this.entity);
        MetricsValues metricsValues = this.metricsQuery.readMetricsValues(metricsCondition, this.duration);
        List times = this.duration.assembleDurationPoints();
        ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(times.size());
        for (int i = 0; i < times.size(); ++i) {
            long retTimestamp = DurationUtils.INSTANCE.parseToDateTime(this.duration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis();
            KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(Long.toString(retTimestamp));
            mqeValue.setEmptyValue(kvInt.isEmptyValue());
            mqeValue.setDoubleValue((double)kvInt.getValue());
            mqeValueList.add(mqeValue);
        }
        Metadata metadata = new Metadata();
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        mqeValues.setMetric(metadata);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
    }

    private void queryLabeledMetrics(String metricName, List<String> queryLabelList, ExpressionResult result) throws IOException {
        MetricsCondition metricsCondition = new MetricsCondition();
        metricsCondition.setName(metricName);
        metricsCondition.setEntity(this.entity);
        List<MetricsValues> metricsValuesList = this.metricsQuery.readLabeledMetricsValues(metricsCondition, queryLabelList, this.duration);
        List times = this.duration.assembleDurationPoints();
        metricsValuesList.forEach(metricsValues -> {
            ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(times.size());
            for (int i = 0; i < times.size(); ++i) {
                long retTimestamp = DurationUtils.INSTANCE.parseToDateTime(this.duration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis();
                KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
                MQEValue mqeValue = new MQEValue();
                mqeValue.setEmptyValue(kvInt.isEmptyValue());
                mqeValue.setId(Long.toString(retTimestamp));
                mqeValueList.add(mqeValue);
                if (kvInt.isEmptyValue()) continue;
                mqeValue.setDoubleValue((double)kvInt.getValue());
            }
            Metadata metadata = new Metadata();
            KeyValue labelValue = new KeyValue("_", metricsValues.getLabel());
            metadata.getLabels().add(labelValue);
            MQEValues mqeValues = new MQEValues();
            mqeValues.setValues(mqeValueList);
            mqeValues.setMetric(metadata);
            result.getResults().add(mqeValues);
        });
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
        result.setLabeledResult(true);
    }
}

