/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.graphql.GraphqlService;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLQueryHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLQueryHandler.class);
    private final GraphqlService graphqlService;

    public GraphQLQueryHandler(GraphQLQueryConfig config, GraphQLSchema schema) {
        int allowedComplexity = config.getMaxQueryComplexity();
        this.graphqlService = GraphqlService.builder().schema(schema).instrumentation(new Instrumentation[]{new MaxQueryComplexityInstrumentation(allowedComplexity, info -> {
            log.warn("Aborting query because it's too complex, maximum allowed is [{}] but was [{}]", (Object)allowedComplexity, (Object)info.getComplexity());
            return true;
        })}).build();
    }

    @Blocking
    @Post(value="/graphql")
    public HttpResponse graphql(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return this.graphqlService.serve(ctx, req);
    }
}

