/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.requests.search.Sorts;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;

public final class SearchBuilder {
    private Integer from;
    private Integer size;
    private QueryBuilder queryBuilder;
    private ImmutableList.Builder<Sort> sort;
    private ImmutableMap.Builder<String, Aggregation> aggregations;

    SearchBuilder() {
    }

    public SearchBuilder from(Integer from) {
        Objects.requireNonNull(from, "from");
        Preconditions.checkArgument((from >= 0 ? 1 : 0) != 0, (String)"from must be >= 0, but was %s", (Object)from);
        this.from = from;
        return this;
    }

    public SearchBuilder size(Integer size) {
        Objects.requireNonNull(size, "size");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"size must be positive, but was %s", (Object)size);
        this.size = size;
        return this;
    }

    public SearchBuilder sort(String by, Sort.Order order) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)by) ? 1 : 0) != 0, (Object)"by cannot be blank");
        Objects.requireNonNull(order, "order");
        this.sort().add((Object)new Sort(by, order));
        return this;
    }

    public SearchBuilder query(QueryBuilder queryBuilder) {
        Preconditions.checkState((this.queryBuilder == null ? 1 : 0) != 0, (Object)"queryBuilder is already set");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder");
        return this;
    }

    public SearchBuilder aggregation(Aggregation aggregation) {
        Objects.requireNonNull(aggregation, "aggregation");
        this.aggregations().put((Object)aggregation.name(), (Object)aggregation);
        return this;
    }

    public SearchBuilder aggregation(AggregationBuilder builder) {
        Objects.requireNonNull(builder, "builder");
        return this.aggregation(builder.build());
    }

    public Search build() {
        Sorts sorts = this.sort == null ? null : new Sorts((ImmutableList<Sort>)this.sort.build());
        ImmutableMap aggregations = this.aggregations == null ? null : this.aggregations().build();
        Query query = this.queryBuilder != null ? this.queryBuilder.build() : null;
        return new Search(this.from, this.size, query, sorts, (ImmutableMap<String, Aggregation>)aggregations);
    }

    private ImmutableList.Builder<Sort> sort() {
        if (this.sort == null) {
            this.sort = ImmutableList.builder();
        }
        return this.sort;
    }

    private ImmutableMap.Builder<String, Aggregation> aggregations() {
        if (this.aggregations == null) {
            this.aggregations = ImmutableMap.builder();
        }
        return this.aggregations;
    }
}

