/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public class JDBCZipkinQueryDAO
implements IZipkinQueryDAO {
    private static final int NAME_QUERY_MAX_SIZE = Integer.MAX_VALUE;
    private static final Gson GSON = new Gson();
    private final JDBCClient h2Client;
    private final TableHelper tableHelper;

    public List<String> getServiceNames() {
        List<String> tables = this.tableHelper.getTablesWithinTTL("zipkin_service_traffic");
        ArrayList services = new ArrayList();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append("service_name").append(" from ").append(table).append(" where ").append("table_name").append(" = ?");
            sql.append(" limit ").append(Integer.MAX_VALUE);
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    services.add(resultSet.getString("service_name"));
                }
                return null;
            }, new Object[]{"zipkin_service_traffic"});
        }
        return services.stream().limit(Integer.MAX_VALUE).collect(Collectors.toList());
    }

    public List<String> getRemoteServiceNames(String serviceName) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("zipkin_service_relation_traffic");
        ArrayList remoteServices = new ArrayList();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(2);
            sql.append("select ").append("remote_service_name").append(" from ").append(table);
            sql.append(" where ");
            sql.append("table_name").append(" = ?");
            condition.add("zipkin_service_relation_traffic");
            sql.append(" and ").append("service_name").append(" = ?");
            sql.append(" limit ").append(Integer.MAX_VALUE);
            condition.add(serviceName);
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    remoteServices.add(resultSet.getString("remote_service_name"));
                }
                return null;
            }, condition.toArray(new Object[0]));
        }
        return remoteServices.stream().limit(Integer.MAX_VALUE).collect(Collectors.toList());
    }

    public List<String> getSpanNames(String serviceName) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("zipkin_service_span_traffic");
        ArrayList spanNames = new ArrayList();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select ").append("span_name").append(" from ").append(table);
            sql.append(" where ");
            sql.append("table_name").append(" = ?");
            condition.add("zipkin_service_span_traffic");
            sql.append(" and ").append("service_name").append(" = ?");
            sql.append(" limit ").append(Integer.MAX_VALUE);
            condition.add(serviceName);
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    spanNames.add(resultSet.getString("span_name"));
                }
                return null;
            }, condition.toArray(new Object[0]));
        }
        return spanNames.stream().limit(Integer.MAX_VALUE).collect(Collectors.toList());
    }

    public List<Span> getTrace(String traceId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("zipkin_span");
        ArrayList<Span> trace = new ArrayList<Span>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table);
            sql.append(" where ");
            sql.append("table_name").append(" = ?");
            condition.add("zipkin_span");
            sql.append(" and ").append("trace_id").append(" = ?");
            condition.add(traceId);
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    trace.add(this.buildSpan(resultSet));
                }
                return null;
            }, condition.toArray(new Object[0]));
        }
        return trace;
    }

    public List<List<Span>> getTraces(QueryRequest request, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead("zipkin_span", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        long startTimeMillis = duration.getStartTimestamp();
        long endTimeMillis = duration.getEndTimestamp();
        HashSet<String> traceIds = new HashSet<String>();
        for (String table : tables) {
            int i;
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> condition = new ArrayList<Object>(5);
            ArrayList annotations = new ArrayList(request.annotationQuery().entrySet());
            sql.append("select ").append(table).append(".").append("trace_id").append(", ").append("min(").append("timestamp_millis").append(")").append(" from ");
            sql.append(table);
            long timeBucket = TableHelper.getTimeBucket(table);
            String tagTable = TableHelper.getTable("zipkin_query", timeBucket);
            if (!CollectionUtils.isEmpty(annotations)) {
                for (i = 0; i < annotations.size(); ++i) {
                    sql.append(" inner join ").append(tagTable).append(" ");
                    sql.append(tagTable + i);
                    sql.append(" on ").append(table).append(".").append("id").append(" = ");
                    sql.append(tagTable + i).append(".").append("id");
                }
            }
            sql.append(" where ");
            sql.append(" 1=1 ");
            if (startTimeMillis > 0L && endTimeMillis > 0L) {
                sql.append(" and ");
                sql.append("timestamp_millis").append(" >= ?");
                condition.add(startTimeMillis);
                sql.append(" and ");
                sql.append("timestamp_millis").append(" <= ?");
                condition.add(endTimeMillis);
                this.buildShardingCondition(sql, condition, startTimeMillis, endTimeMillis);
            }
            if (request.minDuration() != null) {
                sql.append(" and ");
                sql.append("duration").append(" >= ?");
                condition.add(request.minDuration());
            }
            if (request.maxDuration() != null) {
                sql.append(" and ");
                sql.append("duration").append(" <= ?");
                condition.add(request.maxDuration());
            }
            if (!StringUtil.isEmpty((String)request.serviceName())) {
                sql.append(" and ");
                sql.append("local_endpoint_service_name").append(" = ?");
                condition.add(request.serviceName());
            }
            if (!StringUtil.isEmpty((String)request.remoteServiceName())) {
                sql.append(" and ");
                sql.append("remote_endpoint_service_name").append(" = ?");
                condition.add(request.remoteServiceName());
            }
            if (!StringUtil.isEmpty((String)request.spanName())) {
                sql.append(" and ");
                sql.append("name").append(" = ?");
                condition.add(request.spanName());
            }
            if (CollectionUtils.isNotEmpty(annotations)) {
                for (i = 0; i < annotations.size(); ++i) {
                    Map.Entry annotation = (Map.Entry)annotations.get(i);
                    if (((String)annotation.getValue()).isEmpty()) {
                        sql.append(" and ").append(tagTable).append(i).append(".");
                        sql.append("query").append(" = ?");
                        condition.add(annotation.getKey());
                        continue;
                    }
                    sql.append(" and ").append(tagTable).append(i).append(".");
                    sql.append("query").append(" = ?");
                    condition.add((String)annotation.getKey() + "=" + (String)annotation.getValue());
                }
            }
            sql.append(" group by ").append("trace_id");
            sql.append(" order by min(").append("timestamp_millis").append(") desc");
            sql.append(" limit ").append(request.limit());
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    traceIds.add(resultSet.getString("trace_id"));
                }
                return null;
            }, condition.toArray(new Object[0]));
        }
        return this.getTraces(traceIds);
    }

    public List<List<Span>> getTraces(Set<String> traceIds) {
        if (CollectionUtils.isEmpty(traceIds)) {
            return new ArrayList<List<Span>>();
        }
        List<String> tables = this.tableHelper.getTablesWithinTTL("zipkin_span");
        ArrayList<List<Span>> traces = new ArrayList<List<Span>>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(5);
            sql.append("select * from ").append(table);
            sql.append(" where ");
            sql.append("table_name").append(" = ?");
            condition.add("zipkin_span");
            int i = 0;
            sql.append(" and ");
            for (String traceId : traceIds) {
                sql.append("trace_id").append(" = ?");
                condition.add(traceId);
                if (i != traceIds.size() - 1) {
                    sql.append(" or ");
                }
                ++i;
            }
            sql.append(" order by ").append("timestamp_millis").append(" desc");
            traces.addAll((Collection)this.h2Client.executeQuery(sql.toString(), this::buildTraces, condition.toArray(new Object[0])));
        }
        return traces;
    }

    private List<List<Span>> buildTraces(ResultSet resultSet) throws SQLException {
        LinkedHashMap groupedByTraceId = new LinkedHashMap();
        while (resultSet.next()) {
            Span span = this.buildSpan(resultSet);
            String traceId = span.traceId();
            groupedByTraceId.putIfAbsent(traceId, new ArrayList());
            ((List)groupedByTraceId.get(traceId)).add(span);
        }
        return new ArrayList<List<Span>>(groupedByTraceId.values());
    }

    private Span buildSpan(ResultSet resultSet) throws SQLException {
        String annotationString;
        Span.Builder span = Span.newBuilder();
        span.traceId(resultSet.getString("trace_id"));
        span.id(resultSet.getString("span_id"));
        span.parentId(resultSet.getString("parent_id"));
        String kind = resultSet.getString("kind");
        if (!StringUtil.isEmpty((String)kind)) {
            span.kind(Span.Kind.valueOf((String)kind));
        }
        span.timestamp(resultSet.getLong("timestamp"));
        span.duration(resultSet.getLong("duration"));
        span.name(resultSet.getString("name"));
        if (resultSet.getString("debug") != null) {
            span.debug(Boolean.TRUE);
        }
        if (resultSet.getString("shared") != null) {
            span.shared(Boolean.TRUE);
        }
        Endpoint.Builder localEndpoint = Endpoint.newBuilder();
        localEndpoint.serviceName(resultSet.getString("local_endpoint_service_name"));
        if (!StringUtil.isEmpty((String)resultSet.getString("local_endpoint_ipv4"))) {
            localEndpoint.parseIp(resultSet.getString("local_endpoint_ipv4"));
        } else {
            localEndpoint.parseIp(resultSet.getString("local_endpoint_ipv6"));
        }
        localEndpoint.port(resultSet.getInt("local_endpoint_port"));
        span.localEndpoint(localEndpoint.build());
        Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
        remoteEndpoint.serviceName(resultSet.getString("remote_endpoint_service_name"));
        if (!StringUtil.isEmpty((String)resultSet.getString("remote_endpoint_ipv4"))) {
            remoteEndpoint.parseIp(resultSet.getString("remote_endpoint_ipv4"));
        } else {
            remoteEndpoint.parseIp(resultSet.getString("remote_endpoint_ipv6"));
        }
        remoteEndpoint.port(resultSet.getInt("remote_endpoint_port"));
        span.remoteEndpoint(remoteEndpoint.build());
        String tagsString = resultSet.getString("tags");
        if (!StringUtil.isEmpty((String)tagsString)) {
            JsonObject tagsJson = (JsonObject)GSON.fromJson(tagsString, JsonObject.class);
            for (Map.Entry tag : tagsJson.entrySet()) {
                span.putTag((String)tag.getKey(), ((JsonElement)tag.getValue()).getAsString());
            }
        }
        if (!StringUtil.isEmpty((String)(annotationString = resultSet.getString("annotations")))) {
            JsonObject annotationJson = (JsonObject)GSON.fromJson(annotationString, JsonObject.class);
            for (Map.Entry annotation : annotationJson.entrySet()) {
                span.addAnnotation(Long.parseLong((String)annotation.getKey()), ((JsonElement)annotation.getValue()).getAsString());
            }
        }
        return span.build();
    }

    protected void buildShardingCondition(StringBuilder sql, List<Object> parameters, long startTimeMillis, long endTimeMillis) {
    }

    @Generated
    public JDBCZipkinQueryDAO(JDBCClient h2Client, TableHelper tableHelper) {
        this.h2Client = h2Client;
        this.tableHelper = tableHelper;
    }
}

