/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common;

import java.time.Clock;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCBatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCHistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCMetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCNetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCServiceLabelQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCStorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCTagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCTopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCTraceQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCUIMenuManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCUITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCZipkinQueryDAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public abstract class JDBCStorageProvider
extends ModuleProvider {
    protected JDBCStorageConfig config;
    protected JDBCClient jdbcClient;
    protected JDBCTableInstaller modelInstaller;
    protected TableHelper tableHelper;

    protected abstract ModelInstaller createModelInstaller();

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleProvider.ConfigCreator<? extends JDBCStorageConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<JDBCStorageConfig>(){

            public Class<JDBCStorageConfig> type() {
                return JDBCStorageConfig.class;
            }

            public void onInitialized(JDBCStorageConfig initialized) {
                JDBCStorageProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.jdbcClient = new JDBCClient(this.config.getProperties());
        this.modelInstaller = (JDBCTableInstaller)this.createModelInstaller();
        this.tableHelper = new TableHelper(this.getManager(), this.jdbcClient);
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        this.registerServiceImplementation(IBatchDAO.class, (Service)new JDBCBatchDAO(this.jdbcClient, this.config.getMaxSizeOfBatchSql(), this.config.getAsyncBatchPersistentPoolSize()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new JDBCStorageDAO(this.jdbcClient));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new JDBCNetworkAddressAliasDAO(this.jdbcClient, this.getManager()));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new JDBCTopologyQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new JDBCMetricsQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new JDBCTraceQueryDAO(this.getManager(), this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new JDBCBrowserLogQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new JDBCMetadataQueryDAO(this.jdbcClient, this.config.getMetadataQueryMaxSize(), this.getManager()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new JDBCAggregationQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new JDBCAlarmQueryDAO(this.jdbcClient, this.getManager(), this.tableHelper));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new JDBCHistoryDeleteDAO(this.jdbcClient, this.tableHelper, this.modelInstaller, Clock.systemDefaultZone()));
        this.registerServiceImplementation(IRecordsQueryDAO.class, (Service)new JDBCRecordsQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new JDBCLogQueryDAO(this.jdbcClient, this.getManager(), this.tableHelper));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new JDBCProfileTaskQueryDAO(this.jdbcClient, this.getManager()));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new JDBCProfileTaskLogQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new JDBCProfileThreadSnapshotQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new JDBCUITemplateManagementDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(UIMenuManagementDAO.class, (Service)new JDBCUIMenuManagementDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new JDBCEventQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IEBPFProfilingTaskDAO.class, (Service)new JDBCEBPFProfilingTaskDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IEBPFProfilingScheduleDAO.class, (Service)new JDBCEBPFProfilingScheduleDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IEBPFProfilingDataDAO.class, (Service)new JDBCEBPFProfilingDataDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IContinuousProfilingPolicyDAO.class, (Service)new JDBCContinuousProfilingPolicyDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IServiceLabelDAO.class, (Service)new JDBCServiceLabelQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(ITagAutoCompleteQueryDAO.class, (Service)new JDBCTagAutoCompleteQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(IZipkinQueryDAO.class, (Service)new JDBCZipkinQueryDAO(this.jdbcClient, this.tableHelper));
        this.registerServiceImplementation(ISpanAttachedEventQueryDAO.class, (Service)new JDBCSpanAttachedEventQueryDAO(this.jdbcClient, this.tableHelper));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_" + this.name(), MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.jdbcClient.registerChecker((HealthChecker)healthChecker);
        try {
            this.jdbcClient.connect();
            this.modelInstaller.start();
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)this.modelInstaller);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

