/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenu;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class UIMenuManagementEsDAO
extends EsDAO
implements UIMenuManagementDAO {
    public UIMenuManagementEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public UIMenu getMenu(String id) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ui_menu");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.ids((String[])new String[]{id})).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (response.getHits().getHits().size() > 0) {
            UIMenu.Builder builder = new UIMenu.Builder();
            SearchHit data = (SearchHit)response.getHits().getHits().get(0);
            return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ui_menu", data.getSource()));
        }
        return null;
    }

    public void saveMenu(UIMenu menu) throws IOException {
        try {
            UIMenu.Builder builder = new UIMenu.Builder();
            ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage("ui_menu");
            builder.entity2Storage(menu, (Convert2Storage)toStorage);
            ((ElasticSearchClient)this.getClient()).forceInsert("ui_menu", menu.id().build(), (Map)toStorage.obtain());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

