/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ContinuousProfilingPolicyEsDAO
extends EsDAO
implements IContinuousProfilingPolicyDAO {
    public ContinuousProfilingPolicyEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public void savePolicy(ContinuousProfilingPolicy policy) throws IOException {
        ContinuousProfilingPolicy.Builder builder = new ContinuousProfilingPolicy.Builder();
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage("continuous_profiling_policy");
        builder.entity2Storage(policy, (Convert2Storage)toStorage);
        boolean exist = ((ElasticSearchClient)this.getClient()).existDoc("continuous_profiling_policy", policy.id().build());
        if (exist) {
            ((ElasticSearchClient)this.getClient()).forceUpdate("continuous_profiling_policy", policy.id().build(), (Map)toStorage.obtain());
        } else {
            ((ElasticSearchClient)this.getClient()).forceInsert("continuous_profiling_policy", policy.id().build(), (Map)toStorage.obtain());
        }
    }

    public List<ContinuousProfilingPolicy> queryPolicies(List<String> serviceIdList) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("continuous_profiling_policy");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.terms((String)"service_id", serviceIdList)).size(Integer.valueOf(serviceIdList.size()));
        return this.buildPolicies(((ElasticSearchClient)this.getClient()).search(index, search.build()));
    }

    private List<ContinuousProfilingPolicy> buildPolicies(SearchResponse response) {
        ArrayList<ContinuousProfilingPolicy> policies = new ArrayList<ContinuousProfilingPolicy>();
        for (SearchHit hit : response.getHits()) {
            Map sourceAsMap = hit.getSource();
            ContinuousProfilingPolicy.Builder builder = new ContinuousProfilingPolicy.Builder();
            policies.add(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("continuous_profiling_policy", sourceAsMap)));
        }
        return policies;
    }
}

