/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.BucketOrder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;

public class AggregationQueryEsDAO
extends EsDAO
implements IAggregationQueryDAO {
    public AggregationQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) {
        BoolQueryBuilder boolQuery;
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        RangeQueryBuilder basicQuery = Query.range((String)"time_bucket").lte((Object)duration.getEndTimeBucket()).gte((Object)duration.getStartTimeBucket());
        SearchBuilder search = Search.builder();
        boolean asc = condition.getOrder().equals((Object)Order.ASC);
        if (CollectionUtils.isEmpty(additionalConditions) && IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            boolQuery = Query.bool().must((QueryBuilder)basicQuery).must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName()));
            search.query((QueryBuilder)boolQuery);
        } else if (CollectionUtils.isEmpty(additionalConditions)) {
            search.query((QueryBuilder)basicQuery);
        } else if (CollectionUtils.isNotEmpty(additionalConditions) && IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            boolQuery = Query.bool().must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName()));
            additionalConditions.forEach(additionalCondition -> boolQuery.must((QueryBuilder)Query.terms((String)additionalCondition.getKey(), (Object[])new Object[]{additionalCondition.getValue()})));
            boolQuery.must((QueryBuilder)basicQuery);
            search.query((QueryBuilder)boolQuery);
        } else {
            boolQuery = Query.bool();
            additionalConditions.forEach(additionalCondition -> boolQuery.must((QueryBuilder)Query.terms((String)additionalCondition.getKey(), (Object[])new Object[]{additionalCondition.getValue()})));
            boolQuery.must((QueryBuilder)basicQuery);
            search.query((QueryBuilder)boolQuery);
        }
        search.aggregation((Aggregation)Aggregation.terms((String)"entity_id").field("entity_id").order(BucketOrder.aggregation((String)realValueColumn, (boolean)asc)).size(condition.getTopN()).subAggregation((AggregationBuilder)Aggregation.avg((String)realValueColumn).field(realValueColumn)).executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).build());
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName()), duration.getStartTimeBucketInSec(), duration.getEndTimeBucketInSec()), search.build());
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        if (Objects.nonNull(response.getAggregations())) {
            Map idTerms = (Map)response.getAggregations().get("entity_id");
            List buckets = (List)idTerms.get("buckets");
            for (Map termsBucket : buckets) {
                SelectedRecord record = new SelectedRecord();
                record.setId((String)termsBucket.get("key"));
                Map value = (Map)termsBucket.get(realValueColumn);
                record.setValue(String.valueOf(((Number)value.get("value")).longValue()));
                topNList.add(record);
            }
        }
        return topNList;
    }
}

