/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import java.io.Serializable;
import java.util.Objects;

@PublicApi
public class SourceLocation
implements Serializable {
    public static final SourceLocation EMPTY = new SourceLocation(-1, -1);
    private final int line;
    private final int column;
    private final String sourceName;

    public SourceLocation(int line, int column) {
        this(line, column, null);
    }

    public SourceLocation(int line, int column, String sourceName) {
        this.line = line;
        this.column = column;
        this.sourceName = sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        if (this.line != that.line) {
            return false;
        }
        if (this.column != that.column) {
            return false;
        }
        return Objects.equals(this.sourceName, that.sourceName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Integer.hashCode(this.line);
        result = 31 * result + Integer.hashCode(this.column);
        result = 31 * result + Objects.hashCode(this.sourceName);
        return result;
    }

    public String toString() {
        return "SourceLocation{line=" + this.line + ", column=" + this.column + (String)(this.sourceName != null ? ", sourceName=" + this.sourceName : "") + "}";
    }
}

