/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.nacos.NacosServerSettings;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosConfigWatcherRegister.class);
    private final NacosServerSettings settings;
    private final ConfigService configService;
    private final Map<String, Optional<String>> configItemKeyedByName;
    private final Map<String, Listener> listenersByKey;

    public NacosConfigWatcherRegister(NacosServerSettings settings) throws NacosException {
        super((long)settings.getPeriod());
        this.settings = settings;
        this.configItemKeyedByName = new ConcurrentHashMap<String, Optional<String>>();
        this.listenersByKey = new ConcurrentHashMap<String, Listener>();
        int port = this.settings.getPort();
        String serverAddr = this.settings.getServerAddr();
        Properties properties = new Properties();
        properties.put("serverAddr", serverAddr + ":" + port);
        properties.put("namespace", settings.getNamespace());
        if (StringUtil.isNotEmpty((String)settings.getUsername())) {
            properties.put("username", settings.getUsername());
            properties.put("password", settings.getPassword());
        } else if (StringUtil.isNotEmpty((String)settings.getAccessKey())) {
            properties.put("accessKey", settings.getAccessKey());
            properties.put("secretKey", settings.getSecretKey());
        }
        this.configService = NacosFactory.createConfigService((Properties)properties);
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        this.removeUninterestedKeys(keys);
        this.registerKeyListeners(keys);
        ConfigTable table = new ConfigTable();
        for (Map.Entry<String, Optional<String>> entry : this.configItemKeyedByName.entrySet()) {
            String key = entry.getKey();
            Optional<String> value = entry.getValue();
            if (value.isPresent()) {
                table.add(new ConfigTable.ConfigItem(key, value.get()));
                continue;
            }
            table.add(new ConfigTable.ConfigItem(key, null));
        }
        return Optional.of(table);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            groupConfigTable.addGroupConfigItems(groupConfigItems);
            String config = null;
            try {
                config = this.configService.getConfig(key, this.settings.getGroup(), 1000L);
                if (StringUtil.isNotEmpty((String)config)) {
                    String[] itemNames = config.split("\\n|\\r\\n");
                    Arrays.stream(itemNames).map(String::trim).forEach(itemName -> {
                        String itemValue = null;
                        try {
                            itemValue = this.configService.getConfig(itemName, this.settings.getGroup(), 1000L);
                        }
                        catch (NacosException e) {
                            log.error("Failed to register Nacos listener for dataId: {}", itemName, (Object)e);
                        }
                        groupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                    });
                }
            }
            catch (NacosException e) {
                log.error("Failed to register Nacos listener for dataId: {}", key, (Object)e);
            }
        });
        return Optional.of(groupConfigTable);
    }

    private void registerKeyListeners(Set<String> keys) {
        String group = this.settings.getGroup();
        for (final String dataId : keys) {
            if (this.listenersByKey.containsKey(dataId)) continue;
            try {
                this.listenersByKey.putIfAbsent(dataId, new Listener(){

                    public Executor getExecutor() {
                        return null;
                    }

                    public void receiveConfigInfo(String configInfo) {
                        NacosConfigWatcherRegister.this.onDataIdValueChanged(dataId, configInfo);
                    }
                });
                this.configService.addListener(dataId, group, this.listenersByKey.get(dataId));
                String config = this.configService.getConfig(dataId, group, 1000L);
                this.onDataIdValueChanged(dataId, config);
            }
            catch (NacosException e) {
                log.warn("Failed to register Nacos listener for dataId: {}", (Object)dataId);
            }
        }
    }

    private void removeUninterestedKeys(Set<String> interestedKeys) {
        String group = this.settings.getGroup();
        HashSet<String> uninterestedKeys = new HashSet<String>(this.listenersByKey.keySet());
        uninterestedKeys.removeAll(interestedKeys);
        uninterestedKeys.forEach(k -> {
            Listener listener = this.listenersByKey.remove(k);
            if (listener != null) {
                this.configService.removeListener(k, group, listener);
            }
        });
    }

    void onDataIdValueChanged(String dataId, String configInfo) {
        if (log.isInfoEnabled()) {
            log.info("Nacos config changed: {}: {}", (Object)dataId, (Object)configInfo);
        }
        this.configItemKeyedByName.put(dataId, Optional.ofNullable(configInfo));
    }
}

