/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.NullableValue;
import org.apache.skywalking.oap.server.core.storage.DAO;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;

public interface IMetricsQueryDAO
extends DAO {
    public NullableValue readMetricsValue(MetricsCondition var1, String var2, Duration var3) throws IOException;

    public MetricsValues readMetricsValues(MetricsCondition var1, String var2, Duration var3) throws IOException;

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition var1, String var2, List<String> var3, Duration var4) throws IOException;

    public HeatMap readHeatMap(MetricsCondition var1, String var2, Duration var3) throws IOException;

    public static class LabeledValue {
        private final String label;
        private final KVInt kv;

        public LabeledValue(String label, String id, long value, boolean isEmptyValue) {
            this.label = label;
            this.kv = new KVInt(id, value, isEmptyValue);
        }
    }

    public static class Util {
        public static IntValues sortValues(IntValues origin, List<String> expectedOrder, int defaultValue) {
            IntValues intValues = new IntValues();
            expectedOrder.forEach(id -> intValues.addKVInt(origin.findValue((String)id, defaultValue)));
            return intValues;
        }

        public static List<MetricsValues> sortValues(List<MetricsValues> origin, List<String> expectedOrder, int defaultValue) {
            for (int i = 0; i < origin.size(); ++i) {
                MetricsValues metricsValues = origin.get(i);
                metricsValues.setValues(Util.sortValues(metricsValues.getValues(), expectedOrder, defaultValue));
            }
            return origin;
        }

        public static List<MetricsValues> composeLabelValue(MetricsCondition condition, List<String> labels, List<String> ids, Map<String, DataTable> idMap) {
            List<Object> allLabels = Objects.isNull(labels) || labels.size() < 1 || labels.stream().allMatch(Strings::isNullOrEmpty) ? idMap.values().stream().flatMap(dataTable -> dataTable.keys().stream()).distinct().collect(Collectors.toList()) : labels;
            int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
            List labeledValues = new TreeSet(allLabels).stream().flatMap(label -> ids.stream().map(id -> {
                DataTable value = idMap.getOrDefault(id, new DataTable());
                return Objects.nonNull(value.get((String)label)) ? new LabeledValue((String)label, (String)id, value.get((String)label), false) : new LabeledValue((String)label, (String)id, defaultValue, true);
            })).collect(Collectors.toList());
            MetricsValues current = new MetricsValues();
            ArrayList<MetricsValues> result = new ArrayList<MetricsValues>();
            for (LabeledValue each : labeledValues) {
                if (Objects.equals(current.getLabel(), each.label)) {
                    current.getValues().addKVInt(each.kv);
                    continue;
                }
                current = new MetricsValues();
                current.setLabel(each.label);
                current.getValues().addKVInt(each.kv);
                result.add(current);
            }
            return result;
        }
    }
}

