/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelManipulator;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelInstaller
implements ModelCreator.CreatingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelInstaller.class);
    protected final Client client;
    protected final ModuleManager moduleManager;

    @Override
    public void whenCreating(Model model) throws StorageException {
        if (RunningMode.isNoInitMode()) {
            while (!this.isExists(model)) {
                try {
                    log.info("table: {} does not exist. OAP is running in 'no-init' mode, waiting... retry 3s later.", (Object)model.getName());
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
            }
        } else if (!this.isExists(model)) {
            log.info("table: {} does not exist", (Object)model.getName());
            this.createTable(model);
        }
    }

    public void start() {
    }

    protected final void overrideColumnName(String columnName, String newName) {
        ModelManipulator modelOverride = (ModelManipulator)this.moduleManager.find("core").provider().getService(ModelManipulator.class);
        modelOverride.overrideColumnName(columnName, newName);
    }

    public abstract boolean isExists(Model var1) throws StorageException;

    public abstract void createTable(Model var1) throws StorageException;

    @Generated
    public ModelInstaller(Client client, ModuleManager moduleManager) {
        this.client = client;
        this.moduleManager = moduleManager;
    }
}

