/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.annotation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public enum ValueColumnMetadata {
    INSTANCE;

    private final Map<String, ValueColumn> mapping = new HashMap<String, ValueColumn>();
    private final HashMap<String, String> columnNameOverrideRule = new HashMap();

    public void putIfAbsent(String modelName, String valueCName, Column.ValueDataType dataType, Function function, int defaultValue, int scopeId) {
        this.mapping.putIfAbsent(modelName, new ValueColumn(valueCName, dataType, function, defaultValue, scopeId));
    }

    public void overrideColumnName(String oldName, String newName) {
        this.columnNameOverrideRule.put(oldName, newName);
    }

    public String getValueCName(String metricsName) {
        String valueCName = this.findColumn((String)metricsName).valueCName;
        return this.columnNameOverrideRule.getOrDefault(valueCName, valueCName);
    }

    public Function getValueFunction(String metricsName) {
        return this.findColumn((String)metricsName).function;
    }

    public int getDefaultValue(String metricsName) {
        return this.findColumn((String)metricsName).defaultValue;
    }

    public Optional<ValueColumn> readValueColumnDefinition(String metricsName) {
        return Optional.ofNullable(this.mapping.get(metricsName));
    }

    public Map<String, ValueColumn> getAllMetadata() {
        return this.mapping;
    }

    public Scope getScope(String metricsName) {
        return Scope.Finder.valueOf(this.findColumn((String)metricsName).scopeId);
    }

    private ValueColumn findColumn(String metricsName) {
        ValueColumn column = this.mapping.get(metricsName);
        if (column == null) {
            throw new RuntimeException("Metrics:" + metricsName + " doesn't have value column definition");
        }
        return column;
    }

    public static class ValueColumn {
        private final String valueCName;
        private final Column.ValueDataType dataType;
        private final Function function;
        private final int defaultValue;
        private final int scopeId;

        @Generated
        public String getValueCName() {
            return this.valueCName;
        }

        @Generated
        public Column.ValueDataType getDataType() {
            return this.dataType;
        }

        @Generated
        public Function getFunction() {
            return this.function;
        }

        @Generated
        public int getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public int getScopeId() {
            return this.scopeId;
        }

        @Generated
        public ValueColumn(String valueCName, Column.ValueDataType dataType, Function function, int defaultValue, int scopeId) {
            this.valueCName = valueCName;
            this.dataType = dataType;
            this.function = function;
            this.defaultValue = defaultValue;
            this.scopeId = scopeId;
        }
    }
}

