/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.Node;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceTopologyBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceTopologyBuilder.class);
    private final IComponentLibraryCatalogService componentLibraryCatalogService;
    private final NetworkAddressAliasCache networkAddressAliasCache;
    private final String userID;

    ServiceTopologyBuilder(ModuleManager moduleManager) {
        this.componentLibraryCatalogService = (IComponentLibraryCatalogService)moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        this.networkAddressAliasCache = (NetworkAddressAliasCache)moduleManager.find("core").provider().getService(NetworkAddressAliasCache.class);
        this.userID = IDManager.ServiceID.buildId("User", false);
    }

    Topology build(List<Call.CallDetail> serviceRelationClientCalls, List<Call.CallDetail> serviceRelationServerCalls) {
        Call call;
        IDManager.ServiceID.ServiceIDDefinition sourceService;
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        LinkedList<Call> calls = new LinkedList<Call>();
        HashMap<String, Call> callMap = new HashMap<String, Call>();
        for (Call.CallDetail clientCall : serviceRelationClientCalls) {
            String relationId;
            sourceService = IDManager.ServiceID.analysisId(clientCall.getSource());
            String sourceServiceId = clientCall.getSource();
            IDManager.ServiceID.ServiceIDDefinition destService = IDManager.ServiceID.analysisId(clientCall.getTarget());
            String targetServiceId = clientCall.getTarget();
            if (this.networkAddressAliasCache.get(destService.getName()) != null) {
                NetworkAddressAlias networkAddressAlias = this.networkAddressAliasCache.get(destService.getName());
                destService = IDManager.ServiceID.analysisId(networkAddressAlias.getRepresentServiceId());
                targetServiceId = IDManager.ServiceID.buildId(destService.getName(), true);
            }
            if (!nodes.containsKey(targetServiceId)) {
                Node conjecturalNode = this.buildNode(targetServiceId, destService);
                nodes.put(targetServiceId, conjecturalNode);
                if (!conjecturalNode.isReal() && StringUtil.isEmpty((String)conjecturalNode.getType())) {
                    conjecturalNode.setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(clientCall.getComponentId()));
                }
            }
            if (!nodes.containsKey(sourceServiceId)) {
                nodes.put(sourceServiceId, this.buildNode(sourceServiceId, sourceService));
            }
            if (!callMap.containsKey(relationId = IDManager.ServiceID.buildRelationId(new IDManager.ServiceID.ServiceRelationDefine(sourceServiceId, targetServiceId)))) {
                call = new Call();
                callMap.put(relationId, call);
                call.setSource(sourceServiceId);
                call.setTarget(targetServiceId);
                call.setId(relationId);
                call.addDetectPoint(DetectPoint.CLIENT);
                call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
                calls.add(call);
                continue;
            }
            call = (Call)callMap.get(relationId);
            call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
        }
        for (Call.CallDetail serverCall : serviceRelationServerCalls) {
            Node serverSideNode;
            String nodeType;
            sourceService = IDManager.ServiceID.analysisId(serverCall.getSource());
            IDManager.ServiceID.ServiceIDDefinition destService = IDManager.ServiceID.analysisId(serverCall.getTarget());
            Node clientSideNode = (Node)nodes.get(serverCall.getSource());
            if (clientSideNode == null) {
                clientSideNode = this.buildNode(serverCall.getSource(), sourceService);
                nodes.put(serverCall.getSource(), clientSideNode);
            }
            if (!clientSideNode.isReal()) {
                clientSideNode.setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(serverCall.getComponentId()));
            }
            if (this.userID.equals(serverCall.getSource())) {
                ((Node)nodes.get(this.userID)).setType("User".toUpperCase());
            }
            if (!nodes.containsKey(serverCall.getTarget())) {
                Node node = this.buildNode(serverCall.getTarget(), destService);
                nodes.put(serverCall.getTarget(), node);
            }
            if ((nodeType = (serverSideNode = (Node)nodes.get(serverCall.getTarget())).getType()) == null || !serverSideNode.hasSetOnceAtServerSide()) {
                serverSideNode.setTypeFromServerSide(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
            } else {
                Integer componentId = this.componentLibraryCatalogService.getComponentId(nodeType);
                if (componentId != null) {
                    if (this.componentLibraryCatalogService.compare(componentId, serverCall.getComponentId())) {
                        serverSideNode.setTypeFromServerSide(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
                    }
                } else {
                    serverSideNode.setTypeFromServerSide(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
                }
            }
            if (!callMap.containsKey(serverCall.getId())) {
                call = new Call();
                callMap.put(serverCall.getId(), call);
                call.setSource(serverCall.getSource());
                call.setTarget(serverCall.getTarget());
                call.setId(serverCall.getId());
                call.addDetectPoint(DetectPoint.SERVER);
                call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
                calls.add(call);
                continue;
            }
            call = (Call)callMap.get(serverCall.getId());
            call.addDetectPoint(DetectPoint.SERVER);
            call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
        }
        Topology topology = new Topology();
        topology.getCalls().addAll(calls);
        topology.getNodes().addAll(nodes.values());
        return topology;
    }

    private Node buildNode(String sourceId, IDManager.ServiceID.ServiceIDDefinition sourceService) {
        Node serviceNode = new Node();
        serviceNode.setId(sourceId);
        serviceNode.setName(sourceService.getName());
        serviceNode.setReal(sourceService.isReal());
        return serviceNode;
    }
}

