/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.ProcessNode;
import org.apache.skywalking.oap.server.core.query.type.ProcessTopology;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTopologyBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessTopologyBuilder.class);
    private final IComponentLibraryCatalogService componentLibraryCatalogService;
    private final IMetricsDAO metricsDAO;
    private Model processTrafficModel;

    public ProcessTopologyBuilder(ModuleManager moduleManager, StorageModels storageModels) {
        StorageDAO storageDAO = (StorageDAO)moduleManager.find("storage").provider().getService(StorageDAO.class);
        this.metricsDAO = storageDAO.newMetricsDao(new ProcessTraffic.Builder());
        for (Model model : storageModels.allModels()) {
            if (!Objects.equals(model.getName(), "process_traffic")) continue;
            this.processTrafficModel = model;
            break;
        }
        if (this.processTrafficModel == null) {
            throw new IllegalStateException("could not found the process traffic model");
        }
        this.componentLibraryCatalogService = (IComponentLibraryCatalogService)moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
    }

    ProcessTopology build(List<Call.CallDetail> clientCalls, List<Call.CallDetail> serverCalls) throws Exception {
        Call call;
        LinkedList<Call> calls = new LinkedList<Call>();
        HashMap<String, Call> callMap = new HashMap<String, Call>();
        Set sourceProcessIdList = Stream.concat(clientCalls.stream(), serverCalls.stream()).map(Call.CallDetail::getSource).collect(Collectors.toSet());
        Set destProcessIdList = Stream.concat(clientCalls.stream(), serverCalls.stream()).map(Call.CallDetail::getTarget).collect(Collectors.toSet());
        sourceProcessIdList.addAll(destProcessIdList);
        Map<String, ProcessNode> nodes = this.metricsDAO.multiGet(this.processTrafficModel, Stream.concat(sourceProcessIdList.stream(), destProcessIdList.stream()).distinct().map(processId -> {
            ProcessTraffic p = new ProcessTraffic();
            p.setProcessId((String)processId);
            return p;
        }).collect(Collectors.toList())).stream().map(t -> (ProcessTraffic)t).collect(Collectors.toMap(m -> m.id().build(), this::buildNode));
        for (Call.CallDetail clientCall : clientCalls) {
            if (callMap.containsKey(clientCall.getId())) continue;
            call = new Call();
            callMap.put(clientCall.getId(), call);
            call.setSource(clientCall.getSource());
            call.setTarget(clientCall.getTarget());
            call.setId(clientCall.getId());
            call.addDetectPoint(DetectPoint.CLIENT);
            call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
            calls.add(call);
        }
        for (Call.CallDetail serverCall : serverCalls) {
            call = (Call)callMap.get(serverCall.getId());
            if (call == null) {
                call = new Call();
                callMap.put(serverCall.getId(), call);
                call.setSource(serverCall.getSource());
                call.setTarget(serverCall.getTarget());
                call.setId(serverCall.getId());
                calls.add(call);
            }
            call.addDetectPoint(DetectPoint.SERVER);
            call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
        }
        ProcessTopology topology = new ProcessTopology();
        topology.getCalls().addAll(calls);
        topology.getNodes().addAll(nodes.values());
        return topology;
    }

    private ProcessNode buildNode(ProcessTraffic traffic) {
        ProcessNode processNode = new ProcessNode();
        processNode.setId(traffic.id().build());
        processNode.setServiceId(traffic.getServiceId());
        processNode.setServiceName(IDManager.ServiceID.analysisId(traffic.getServiceId()).getName());
        processNode.setServiceInstanceId(traffic.getInstanceId());
        processNode.setServiceInstanceName(IDManager.ServiceInstanceID.analysisId(traffic.getInstanceId()).getName());
        processNode.setName(traffic.getName());
        processNode.setReal(!Objects.equals(traffic.getDetectType(), ProcessDetectType.VIRTUAL.value()));
        return processNode;
    }
}

