/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.NullableValue;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsQueryService.class);
    private final ModuleManager moduleManager;
    private IMetricsQueryDAO metricQueryDAO;

    public MetricsQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetricsQueryDAO getMetricQueryDAO() {
        if (this.metricQueryDAO == null) {
            this.metricQueryDAO = (IMetricsQueryDAO)this.moduleManager.find("storage").provider().getService(IMetricsQueryDAO.class);
        }
        return this.metricQueryDAO;
    }

    public NullableValue readMetricsValue(MetricsCondition condition, Duration duration) throws IOException {
        return this.getMetricQueryDAO().readMetricsValue(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, Duration duration) throws IOException {
        return this.getMetricQueryDAO().readMetricsValues(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, List<String> labels, Duration duration) throws IOException {
        return this.getMetricQueryDAO().readLabeledMetricsValues(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), labels, duration);
    }

    public HeatMap readHeatMap(MetricsCondition condition, Duration duration) throws IOException {
        return this.getMetricQueryDAO().readHeatMap(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }
}

