/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class MetadataQueryService
implements org.apache.skywalking.oap.server.library.module.Service {
    private final ModuleManager moduleManager;
    private final LoadingCache<Boolean, Map<String, List<Service>>> serviceCache;
    private IMetadataQueryDAO metadataQueryDAO;

    public MetadataQueryService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.serviceCache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite((long)moduleConfig.getServiceCacheRefreshInterval(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Boolean, Map<String, List<Service>>>(){

            public Map<String, List<Service>> load(Boolean key) throws Exception {
                return MetadataQueryService.this.mapAllServices();
            }
        });
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    public Set<String> listLayers() throws IOException {
        return Arrays.stream(Layer.values()).filter(layer -> layer.value() > 0).map(Enum::name).collect(Collectors.toSet());
    }

    public List<Service> listServices(String layer, String group) throws IOException {
        return this.combineServices(((Map)this.serviceCache.get((Object)true)).values().stream().flatMap(Collection::stream).filter(svc -> {
            if (StringUtils.isNotEmpty((CharSequence)layer) && !svc.getLayers().contains(layer)) {
                return false;
            }
            return StringUtils.isEmpty((CharSequence)group) || Objects.equals(svc.getGroup(), group);
        }).collect(Collectors.toList()));
    }

    public Service getService(String serviceId) throws IOException {
        List<Service> services = this.combineServices((List)((Map)this.serviceCache.get((Object)true)).get(serviceId));
        return CollectionUtils.isNotEmpty(services) ? services.get(0) : null;
    }

    public ServiceInstance getInstance(String instanceId) throws IOException {
        return this.getMetadataQueryDAO().getInstance(instanceId);
    }

    public List<ServiceInstance> listInstances(Duration duration, String serviceId) throws IOException {
        if (duration.getStartTimestamp() >= duration.getEndTimestamp()) {
            return Collections.emptyList();
        }
        return this.getMetadataQueryDAO().listInstances(duration, serviceId).stream().distinct().collect(Collectors.toList());
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) throws IOException {
        return this.getMetadataQueryDAO().findEndpoint(keyword, serviceId, limit).stream().distinct().collect(Collectors.toList());
    }

    public EndpointInfo getEndpointInfo(String endpointId) throws IOException {
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
        EndpointInfo endpointInfo = new EndpointInfo();
        endpointInfo.setId(endpointId);
        endpointInfo.setName(endpointIDDefinition.getEndpointName());
        endpointInfo.setServiceId(endpointIDDefinition.getServiceId());
        endpointInfo.setServiceName(serviceIDDefinition.getName());
        return endpointInfo;
    }

    public List<Process> listProcesses(Duration duration, String instanceId) throws IOException {
        if (duration.getEndTimeBucket() < duration.getStartTimeBucket()) {
            return Collections.emptyList();
        }
        return this.getMetadataQueryDAO().listProcesses(instanceId, duration, true);
    }

    public Process getProcess(String processId) throws IOException {
        if (StringUtils.isEmpty((CharSequence)processId)) {
            return null;
        }
        return this.getMetadataQueryDAO().getProcess(processId);
    }

    public Long estimateProcessScale(String serviceId, List<String> labels) throws IOException {
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            return 0L;
        }
        long endTimestamp = System.currentTimeMillis();
        long startTimestamp = endTimestamp - TimeUnit.MINUTES.toMillis(10L);
        List<Process> processes = this.getMetadataQueryDAO().listProcesses(serviceId, ProfilingSupportStatus.SUPPORT_EBPF_PROFILING, TimeBucket.getTimeBucket(startTimestamp, DownSampling.Minute), TimeBucket.getTimeBucket(endTimestamp, DownSampling.Minute));
        return CollectionUtils.isEmpty(processes) ? 0L : processes.stream().filter(p -> p.getLabels().containsAll(labels)).count();
    }

    private Map<String, List<Service>> mapAllServices() throws Exception {
        List<Service> services = this.getMetadataQueryDAO().listServices();
        return services.stream().peek(service -> {
            if (service.getGroup() == null) {
                service.setGroup("");
            }
        }).collect(Collectors.toMap(Service::getId, s -> new ArrayList<Service>(List.of(s)), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }));
    }

    private List<Service> combineServices(List<Service> services) {
        if (CollectionUtils.isEmpty(services)) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(services.stream().collect(Collectors.toMap(Service::getName, service -> service, (s1, s2) -> {
            s1.getLayers().addAll(s2.getLayers());
            return s1;
        })).values());
    }
}

