/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import com.google.common.hash.Hashing;
import com.linecorp.armeria.internal.shaded.guava.base.Charsets;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingScheduleRecord;
import org.apache.skywalking.oap.server.core.source.EBPFProcessProfilingSchedule;

public class EBPFProcessProfilingScheduleDispatcher
implements SourceDispatcher<EBPFProcessProfilingSchedule> {
    @Override
    public void dispatch(EBPFProcessProfilingSchedule source) {
        EBPFProfilingScheduleRecord traffic = new EBPFProfilingScheduleRecord();
        traffic.setTaskId(source.getTaskId());
        traffic.setProcessId(source.getProcessId());
        traffic.setStartTime(source.getStartTime());
        traffic.setEndTime(source.getCurrentTime());
        traffic.setTimeBucket(TimeBucket.getMinuteTimeBucket(source.getCurrentTime()));
        traffic.setScheduleId(Hashing.sha256().newHasher().putString((CharSequence)String.format("%s_%s_%d", source.getTaskId(), source.getProcessId(), source.getStartTime()), Charsets.UTF_8).hash().toString());
        MetricsStreamProcessor.getInstance().in(traffic);
    }
}

