/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import io.vavr.Tuple2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.skywalking.oap.server.ai.pipeline.services.api.HttpUriRecognition;
import org.apache.skywalking.oap.server.core.config.group.openapi.EndpointGroupingRule4Openapi;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.QuickUriGroupingRule;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.library.util.StringFormatGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointNameGrouping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointNameGrouping.class);
    private volatile QuickUriGroupingRule endpointGroupingRule;
    private volatile EndpointGroupingRule4Openapi endpointGroupingRule4Openapi;
    private volatile QuickUriGroupingRule quickUriGroupingRule;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, ArrayBlockingQueue<String>>> cachedHttpUris = new ConcurrentHashMap();
    private final AtomicInteger aiPipelineExecutionCounter = new AtomicInteger(0);
    private int maxHttpUrisNumberPerService = 3000;

    public Tuple2<String, Boolean> format(String serviceName, String endpointName) {
        Tuple2<String, Boolean> formattedName = new Tuple2<String, Boolean>((Object)endpointName, (Object)Boolean.FALSE);
        if (this.endpointGroupingRule4Openapi != null) {
            formattedName = this.formatByOpenapi(serviceName, endpointName);
        }
        if (!((Boolean)formattedName._2()).booleanValue() && this.endpointGroupingRule != null) {
            formattedName = this.formatByCustom(serviceName, endpointName);
        }
        if (!((Boolean)formattedName._2()).booleanValue() && this.quickUriGroupingRule != null) {
            formattedName = this.formatByQuickUriPattern(serviceName, endpointName);
            ConcurrentHashMap svrHttpUris = this.cachedHttpUris.computeIfAbsent(serviceName, k -> new ConcurrentHashMap());
            if (svrHttpUris.size() < this.maxHttpUrisNumberPerService) {
                if (((Boolean)formattedName._2()).booleanValue()) {
                    ArrayBlockingQueue formattedURIs = svrHttpUris.computeIfAbsent((String)formattedName._1(), k -> new ArrayBlockingQueue(10));
                    if (formattedURIs.size() < 10) {
                        formattedURIs.offer(endpointName);
                    }
                } else {
                    svrHttpUris.computeIfAbsent(endpointName, k -> new ArrayBlockingQueue(1));
                }
            }
        }
        return formattedName;
    }

    private Tuple2<String, Boolean> formatByCustom(String serviceName, String endpointName) {
        StringFormatGroup.FormatResult formatResult = this.endpointGroupingRule.format(serviceName, endpointName);
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            if (formatResult.isMatch()) {
                log.debug("Endpoint {} of Service {} has been renamed in group {} by endpointGroupingRule", new Object[]{endpointName, serviceName, formatResult.getName()});
            } else {
                log.trace("Endpoint {} of Service {} keeps unchanged.", (Object)endpointName, (Object)serviceName);
            }
        }
        return new Tuple2((Object)formatResult.getReplacedName(), (Object)formatResult.isMatch());
    }

    private Tuple2<String, Boolean> formatByOpenapi(String serviceName, String endpointName) {
        StringFormatGroup.FormatResult formatResult = this.endpointGroupingRule4Openapi.format(serviceName, endpointName);
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            if (formatResult.isMatch()) {
                log.debug("Endpoint {} of Service {} has been renamed in group {} by endpointGroupingRule4Openapi", new Object[]{endpointName, serviceName, formatResult.getName()});
            } else {
                log.trace("Endpoint {} of Service {} keeps unchanged.", (Object)endpointName, (Object)serviceName);
            }
        }
        return new Tuple2((Object)formatResult.getReplacedName(), (Object)formatResult.isMatch());
    }

    private Tuple2<String, Boolean> formatByQuickUriPattern(String serviceName, String endpointName) {
        StringFormatGroup.FormatResult formatResult = this.quickUriGroupingRule.format(serviceName, endpointName);
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            if (formatResult.isMatch()) {
                log.debug("Endpoint {} of Service {} has been renamed in group {} by AI/ML-powered URI pattern recognition", new Object[]{endpointName, serviceName, formatResult.getName()});
            } else {
                log.trace("Endpoint {} of Service {} keeps unchanged.", (Object)endpointName, (Object)serviceName);
            }
        }
        return new Tuple2((Object)formatResult.getReplacedName(), (Object)formatResult.isMatch());
    }

    public void startHttpUriRecognitionSvr(HttpUriRecognition httpUriRecognitionSvr, MetadataQueryService metadataQueryService, int syncPeriodHttpUriRecognitionPattern, int trainingPeriodHttpUriRecognitionPattern, int maxEndpointCandidatePerSvr) {
        this.maxHttpUrisNumberPerService = maxEndpointCandidatePerSvr;
        if (!httpUriRecognitionSvr.isInitialized()) {
            return;
        }
        this.quickUriGroupingRule = new QuickUriGroupingRule();
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(() -> {
            int currentExecutionCounter = this.aiPipelineExecutionCounter.incrementAndGet();
            if (currentExecutionCounter % trainingPeriodHttpUriRecognitionPattern == 0) {
                this.cachedHttpUris.forEach((serviceName, httpUris) -> {
                    ArrayList candidates4UriPatterns = new ArrayList(3000);
                    httpUris.forEach((uri, candidates) -> {
                        if (candidates.size() == 0) {
                            candidates4UriPatterns.add(new HttpUriRecognition.HTTPUri(uri));
                        } else {
                            String candidateUri;
                            while ((candidateUri = (String)candidates.poll()) != null) {
                                candidates4UriPatterns.add(new HttpUriRecognition.HTTPUri(candidateUri));
                            }
                        }
                    });
                    httpUris.clear();
                    httpUriRecognitionSvr.feedRawData(serviceName, candidates4UriPatterns);
                });
            }
            if (currentExecutionCounter % syncPeriodHttpUriRecognitionPattern == 0) {
                try {
                    metadataQueryService.listServices(null, null).forEach(service -> {
                        List patterns = httpUriRecognitionSvr.fetchAllPatterns(service.getName());
                        if (CollectionUtils.isNotEmpty((List)patterns)) {
                            StringFormatGroup group = new StringFormatGroup(patterns.size());
                            patterns.forEach(p -> this.quickUriGroupingRule.addRule(service.getName(), p.getPattern()));
                        }
                    });
                }
                catch (IOException e) {
                    log.error("Fail to load all services.", (Throwable)e);
                }
            }
        }, t -> log.error("Fail to recognize URI patterns.", t)), 60L, 1L, TimeUnit.SECONDS);
    }

    @Generated
    public void setEndpointGroupingRule(QuickUriGroupingRule endpointGroupingRule) {
        this.endpointGroupingRule = endpointGroupingRule;
    }

    @Generated
    public void setEndpointGroupingRule4Openapi(EndpointGroupingRule4Openapi endpointGroupingRule4Openapi) {
        this.endpointGroupingRule4Openapi = endpointGroupingRule4Openapi;
    }

    @Generated
    public void setQuickUriGroupingRule(QuickUriGroupingRule quickUriGroupingRule) {
        this.quickUriGroupingRule = quickUriGroupingRule;
    }
}

