/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;

public class MetricsSessionCache {
    private final Map<Metrics, Metrics> sessionCache = new ConcurrentHashMap<Metrics, Metrics>(100);
    private long timeoutThreshold;

    public MetricsSessionCache(long timeoutThreshold) {
        this.timeoutThreshold = timeoutThreshold;
    }

    Metrics get(Metrics metrics) {
        return this.sessionCache.get(metrics);
    }

    public Metrics remove(Metrics metrics) {
        return this.sessionCache.remove(metrics);
    }

    public void put(Metrics metrics) {
        this.sessionCache.put(metrics, metrics);
    }

    void removeExpired() {
        Iterator<Metrics> iterator = this.sessionCache.values().iterator();
        long timestamp = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Metrics metrics = iterator.next();
            if (!metrics.isExpired(timestamp, this.timeoutThreshold)) continue;
            iterator.remove();
        }
    }

    @Generated
    void setTimeoutThreshold(long timeoutThreshold) {
        this.timeoutThreshold = timeoutThreshold;
    }
}

