/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.MergableBufferedData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricStreamKind;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAggregateWorker
extends AbstractWorker<Metrics> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsAggregateWorker.class);
    public final long l1FlushPeriod;
    private AbstractWorker<Metrics> nextWorker;
    private final DataCarrier<Metrics> dataCarrier;
    private final MergableBufferedData<Metrics> mergeDataCache;
    private CounterMetrics aggregationCounter;
    private long lastSendTime = 0L;

    MetricsAggregateWorker(ModuleDefineHolder moduleDefineHolder, AbstractWorker<Metrics> nextWorker, String modelName, long l1FlushPeriod, MetricStreamKind kind) {
        super(moduleDefineHolder);
        this.nextWorker = nextWorker;
        this.mergeDataCache = new MergableBufferedData();
        String name = "METRICS_L1_AGGREGATION";
        int queueChannelSize = 2;
        int queueBufferSize = 10000;
        if (MetricStreamKind.MAL == kind) {
            queueChannelSize = 1;
            queueBufferSize = 1000;
        }
        this.dataCarrier = new DataCarrier("MetricsAggregateWorker." + modelName, name, queueChannelSize, queueBufferSize);
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, BulkConsumePool.Creator.recommendMaxSize() * 2, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new AggregatorConsumer());
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.aggregationCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "1", "minute"}));
        this.l1FlushPeriod = l1FlushPeriod;
    }

    @Override
    public final void in(Metrics metrics) {
        this.dataCarrier.produce((Object)metrics);
    }

    private void onWork(List<Metrics> metricsList) {
        metricsList.forEach(metrics -> {
            this.aggregationCounter.inc();
            this.mergeDataCache.accept((Metrics)metrics);
        });
        this.flush();
    }

    private void flush() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSendTime > this.l1FlushPeriod) {
            this.mergeDataCache.read().forEach(data -> this.nextWorker.in((Metrics)data));
            this.lastSendTime = currentTime;
        }
    }

    private class AggregatorConsumer
    implements IConsumer<Metrics> {
        private AggregatorConsumer() {
        }

        public void consume(List<Metrics> data) {
            MetricsAggregateWorker.this.onWork(data);
        }

        public void onError(List<Metrics> data, Throwable t) {
            log.error(t.getMessage(), t);
        }

        public void nothingToConsume() {
            MetricsAggregateWorker.this.flush();
        }
    }
}

