/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;

@MetricsFunction(functionName="percentile")
public abstract class PercentileMetrics
extends Metrics
implements MultiIntValuesHolder {
    protected static final String DATASET = "dataset";
    protected static final String VALUE = "datatable_value";
    protected static final String PRECISION = "precision";
    private static final int[] RANKS = new int[]{50, 75, 90, 95, 99};
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private DataTable percentileValues = new DataTable(RANKS.length);
    @Column(name="precision", storageOnly=true)
    @BanyanDB.MeasureField
    private int precision;
    @Column(name="dataset", storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable dataset = new DataTable(30);
    private boolean isCalculated;

    @Entrance
    public final void combine(@SourceFrom int value, @Arg int precision) {
        this.isCalculated = false;
        this.precision = precision;
        String index = String.valueOf(value / precision);
        this.dataset.valueAccumulation(index, 1L);
    }

    @Override
    public boolean combine(Metrics metrics) {
        this.isCalculated = false;
        PercentileMetrics percentileMetrics = (PercentileMetrics)metrics;
        this.dataset.append(percentileMetrics.dataset);
        return true;
    }

    @Override
    public final void calculate() {
        if (!this.isCalculated) {
            long total = this.dataset.sumOfValues();
            int[] roofs = new int[RANKS.length];
            for (int i = 0; i < RANKS.length; ++i) {
                roofs[i] = Math.round((float)(total * (long)RANKS[i]) * 1.0f / 100.0f);
            }
            int count = 0;
            List<String> sortedKeys = this.dataset.sortedKeys(Comparator.comparingInt(Integer::parseInt));
            int loopIndex = 0;
            for (String key : sortedKeys) {
                int roof;
                Long value = this.dataset.get(key);
                count = (int)((long)count + value);
                for (int rankIdx = loopIndex; rankIdx < roofs.length && count >= (roof = roofs[rankIdx]); ++rankIdx) {
                    this.percentileValues.put(String.valueOf(rankIdx), Long.parseLong(key) * (long)this.precision);
                    ++loopIndex;
                }
            }
        }
    }

    @Override
    public int[] getValues() {
        return this.percentileValues.sortedValues(Comparator.comparingInt(Integer::parseInt)).stream().flatMapToInt(l -> IntStream.of(l.intValue())).toArray();
    }

    @Generated
    public DataTable getPercentileValues() {
        return this.percentileValues;
    }

    @Generated
    public void setPercentileValues(DataTable percentileValues) {
        this.percentileValues = percentileValues;
    }

    @Generated
    public int getPrecision() {
        return this.precision;
    }

    @Generated
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }
}

