/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="cpm")
public abstract class CPMMetrics
extends Metrics
implements LongValueHolder {
    protected static final String VALUE = "value";
    protected static final String TOTAL = "total";
    @Column(name="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    @BanyanDB.MeasureField
    private long value;
    @Column(name="total", storageOnly=true)
    @BanyanDB.MeasureField
    private long total;

    @Entrance
    public final void combine(@ConstOne long count) {
        this.total += count;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        CPMMetrics cpmMetrics = (CPMMetrics)metrics;
        this.combine(cpmMetrics.total);
        return true;
    }

    @Override
    public void calculate() {
        this.value = this.total / this.getDurationInMinute();
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }
}

