/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.sum;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="sum")
public abstract class SumFunction
extends Meter
implements AcceptableValue<Long>,
LongValueHolder {
    protected static final String VALUE = "value";
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @Column(name="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Sum)
    @BanyanDB.MeasureField
    private long value;

    @Entrance
    public final void combine(@SourceFrom long value) {
        this.setValue(this.value + value);
    }

    @Override
    public final boolean combine(Metrics metrics) {
        SumFunction sumFunc = (SumFunction)metrics;
        this.combine(sumFunc.getValue());
        return true;
    }

    @Override
    public final void calculate() {
    }

    @Override
    public Metrics toHour() {
        SumFunction metrics = (SumFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        SumFunction metrics = (SumFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.getEntityId().hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setValue(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setServiceId(remoteData.getDataStrings(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getValue());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getServiceId());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void accept(MeterEntity entity, Long value) {
        this.setEntityId(entity.id());
        this.setServiceId(entity.serviceId());
        this.setValue(this.getValue() + value);
    }

    @Override
    public Class<? extends StorageBuilder<?>> builder() {
        return SumStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SumFunction)) {
            return false;
        }
        SumFunction function = (SumFunction)o;
        return Objects.equals(this.getEntityId(), function.getEntityId()) && Objects.equals(this.getTimeBucket(), function.getTimeBucket());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getEntityId(), this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "SumFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    public static class SumStorageBuilder
    implements StorageBuilder<SumFunction> {
        @Override
        public SumFunction storage2Entity(Convert2Entity converter) {
            SumFunction metrics = new SumFunction(){

                @Override
                public AcceptableValue<Long> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(((Number)converter.get(SumFunction.VALUE)).longValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(SumFunction storageData, Convert2Storage converter) {
            converter.accept(SumFunction.VALUE, storageData.getValue());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

