/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.BucketedValues;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="percentile")
public abstract class PercentileFunction
extends Meter
implements AcceptableValue<PercentileArgument>,
MultiIntValuesHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PercentileFunction.class);
    public static final String DATASET = "dataset";
    public static final String RANKS = "ranks";
    public static final String VALUE = "datatable_value";
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private DataTable percentileValues = new DataTable(10);
    @Column(name="dataset", storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable dataset = new DataTable(30);
    @Column(name="ranks", storageOnly=true)
    @BanyanDB.MeasureField
    private IntList ranks = new IntList(10);
    private boolean isCalculated = false;

    @Override
    public void accept(MeterEntity entity, PercentileArgument value) {
        if (this.dataset.size() > 0 && !value.getBucketedValues().isCompatible(this.dataset)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current PercentileFunction[" + this.dataset + "]");
        }
        for (int rank : value.getRanks()) {
            if (rank > 0) continue;
            throw new IllegalArgumentException("Illegal rank value " + rank + ", must be positive");
        }
        if (this.ranks.size() > 0) {
            if (this.ranks.size() != value.getRanks().length) {
                throw new IllegalArgumentException("Incompatible ranks size = [" + value.getRanks().length + "] for current PercentileFunction[" + this.ranks.size() + "]");
            }
            for (int rank : value.getRanks()) {
                if (this.ranks.include(rank)) continue;
                throw new IllegalArgumentException("Rank " + rank + " doesn't exist in the previous ranks " + this.ranks);
            }
        } else {
            for (int rank : value.getRanks()) {
                this.ranks.add(rank);
            }
        }
        this.entityId = entity.id();
        long[] values = value.getBucketedValues().getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBucketedValues().getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            long bucketValue = values[i];
            this.dataset.valueAccumulation(bucketName, bucketValue);
        }
        this.isCalculated = false;
    }

    @Override
    public boolean combine(Metrics metrics) {
        PercentileFunction percentile = (PercentileFunction)metrics;
        if (!this.dataset.keysEqual(percentile.getDataset())) {
            log.warn("Incompatible input [{}}] for current PercentileFunction[{}], entity {}", new Object[]{percentile, this, this.entityId});
            return true;
        }
        if (this.ranks.size() > 0) {
            IntList ranksOfThat = percentile.getRanks();
            if (this.ranks.size() != ranksOfThat.size()) {
                log.warn("Incompatible ranks size = [{}}] for current PercentileFunction[{}]", (Object)ranksOfThat.size(), (Object)this.ranks.size());
                return true;
            }
            if (!this.ranks.equals(ranksOfThat)) {
                log.warn("Rank {} doesn't exist in the previous ranks {}", (Object)ranksOfThat, (Object)this.ranks);
                return true;
            }
        }
        this.dataset.append(percentile.dataset);
        this.isCalculated = false;
        return true;
    }

    @Override
    public void calculate() {
        if (!this.isCalculated) {
            long total = this.dataset.sumOfValues();
            int[] roofs = new int[this.ranks.size()];
            for (int i = 0; i < this.ranks.size(); ++i) {
                roofs[i] = Math.round((float)(total * (long)this.ranks.get(i)) * 1.0f / 100.0f);
            }
            int count = 0;
            List<String> sortedKeys = this.dataset.sortedKeys(Comparator.comparingInt(Integer::parseInt));
            int loopIndex = 0;
            for (String key : sortedKeys) {
                int roof;
                Long value = this.dataset.get(key);
                count = (int)((long)count + value);
                for (int rankIdx = loopIndex; rankIdx < roofs.length && count >= (roof = roofs[rankIdx]); ++rankIdx) {
                    this.percentileValues.put(String.valueOf(this.ranks.get(rankIdx)), Long.parseLong(key));
                    ++loopIndex;
                }
            }
        }
    }

    @Override
    public Metrics toHour() {
        PercentileFunction metrics = (PercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setDataset(this.getDataset());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        PercentileFunction metrics = (PercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setDataset(this.getDataset());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public int[] getValues() {
        return this.percentileValues.sortedValues(Comparator.comparingInt(Integer::parseInt)).stream().flatMapToInt(l -> IntStream.of(l.intValue())).toArray();
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setDataset(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setRanks(new IntList(remoteData.getDataObjectStrings(1)));
        this.setPercentileValues(new DataTable(remoteData.getDataObjectStrings(2)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.dataset.toStorageData());
        remoteBuilder.addDataObjectStrings(this.ranks.toStorageData());
        remoteBuilder.addDataObjectStrings(this.percentileValues.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public Class<? extends StorageBuilder> builder() {
        return PercentileFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PercentileFunction)) {
            return false;
        }
        PercentileFunction function = (PercentileFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getPercentileValues() {
        return this.percentileValues;
    }

    @Generated
    public void setPercentileValues(DataTable percentileValues) {
        this.percentileValues = percentileValues;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    @Generated
    public IntList getRanks() {
        return this.ranks;
    }

    @Generated
    public void setRanks(IntList ranks) {
        this.ranks = ranks;
    }

    public static class PercentileArgument {
        private final BucketedValues bucketedValues;
        private final int[] ranks;

        @Generated
        public PercentileArgument(BucketedValues bucketedValues, int[] ranks) {
            this.bucketedValues = bucketedValues;
            this.ranks = ranks;
        }

        @Generated
        public BucketedValues getBucketedValues() {
            return this.bucketedValues;
        }

        @Generated
        public int[] getRanks() {
            return this.ranks;
        }
    }

    public static class PercentileFunctionBuilder
    implements StorageBuilder<PercentileFunction> {
        @Override
        public PercentileFunction storage2Entity(Convert2Entity converter) {
            PercentileFunction metrics = new PercentileFunction(){

                @Override
                public AcceptableValue<PercentileArgument> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setDataset(new DataTable((String)converter.get(PercentileFunction.DATASET)));
            metrics.setRanks(new IntList((String)converter.get(PercentileFunction.RANKS)));
            metrics.setPercentileValues(new DataTable((String)converter.get(PercentileFunction.VALUE)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(PercentileFunction storageData, Convert2Storage converter) {
            converter.accept(PercentileFunction.DATASET, storageData.getDataset());
            converter.accept(PercentileFunction.RANKS, storageData.getRanks());
            converter.accept(PercentileFunction.VALUE, storageData.getPercentileValues());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

