/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.service;

import lombok.Generated;
import org.apache.logging.log4j.util.Base64Util;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="service_traffic", scopeId=1, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
public class ServiceTraffic
extends Metrics {
    public static final String INDEX_NAME = "service_traffic";
    public static final String NAME = "service_traffic_name";
    public static final String SHORT_NAME = "short_name";
    public static final String SERVICE_ID = "service_id";
    public static final String GROUP = "service_group";
    public static final String LAYER = "layer";
    @Column(name="service_traffic_name")
    @ElasticSearch.Column(legacyName="name")
    @ElasticSearch.MatchQuery
    @BanyanDB.SeriesID(index=1)
    private String name = "";
    @Column(name="short_name")
    private String shortName = "";
    @Column(name="service_id")
    private String serviceId;
    @Column(name="service_group")
    private String group;
    @Column(name="layer")
    @BanyanDB.SeriesID(index=0)
    private Layer layer = Layer.UNDEFINED;

    @Override
    protected StorageID id0() {
        String id = this.layer != null ? Base64Util.encode((String)this.name) + "." + this.layer.value() : Base64Util.encode((String)this.name) + "." + Layer.UNDEFINED.value();
        return new StorageID().appendMutant(new String[]{NAME, LAYER}, id);
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setName(remoteData.getDataStrings(0));
        this.setLayer(Layer.valueOf(remoteData.getDataIntegers(0)));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.name);
        builder.addDataIntegers(this.layer.value());
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    public String getServiceId() {
        if (this.serviceId == null) {
            this.serviceId = IDManager.ServiceID.buildId(this.name, this.layer.isNormal());
        }
        return this.serviceId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceTraffic)) {
            return false;
        }
        ServiceTraffic other = (ServiceTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        return !(this$layer == null ? other$layer != null : !((Object)((Object)this$layer)).equals((Object)other$layer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)((Object)$layer)).hashCode());
        return result;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    public static class Builder
    implements StorageBuilder<ServiceTraffic> {
        @Override
        public ServiceTraffic storage2Entity(Convert2Entity converter) {
            ServiceTraffic serviceTraffic = new ServiceTraffic();
            serviceTraffic.setName((String)converter.get(ServiceTraffic.NAME));
            serviceTraffic.setShortName((String)converter.get(ServiceTraffic.SHORT_NAME));
            serviceTraffic.setGroup((String)converter.get(ServiceTraffic.GROUP));
            if (converter.get(ServiceTraffic.LAYER) != null) {
                serviceTraffic.setLayer(Layer.valueOf(((Number)converter.get(ServiceTraffic.LAYER)).intValue()));
            } else {
                serviceTraffic.setLayer(Layer.UNDEFINED);
            }
            if (converter.get("time_bucket") != null) {
                serviceTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            }
            return serviceTraffic;
        }

        @Override
        public void entity2Storage(ServiceTraffic storageData, Convert2Storage converter) {
            String serviceName = storageData.getName();
            storageData.setShortName(serviceName);
            int groupIdx = serviceName.indexOf("::");
            if (groupIdx > 0) {
                storageData.setGroup(serviceName.substring(0, groupIdx));
                storageData.setShortName(serviceName.substring(groupIdx + 2));
            }
            converter.accept(ServiceTraffic.NAME, serviceName);
            converter.accept(ServiceTraffic.SHORT_NAME, storageData.getShortName());
            converter.accept(ServiceTraffic.SERVICE_ID, storageData.getServiceId());
            converter.accept(ServiceTraffic.GROUP, storageData.getGroup());
            Layer layer = storageData.getLayer();
            converter.accept(ServiceTraffic.LAYER, layer != null ? layer.value() : Layer.UNDEFINED.value());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

