/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.Collections;
import java.util.List;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFuncFactory;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AvgAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MaxAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MinAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.SumAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.mqe.rt.type.Metadata;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class AggregateLabelsOp {
    public static ExpressionResult doAggregateLabelsOp(ExpressionResult result, int funcType) throws IllegalExpressionException {
        switch (funcType) {
            case 23: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, AvgAggregateLabelsFunc::new);
            }
            case 28: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, SumAggregateLabelsFunc::new);
            }
            case 26: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, MaxAggregateLabelsFunc::new);
            }
            case 27: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, MinAggregateLabelsFunc::new);
            }
        }
        throw new IllegalExpressionException("Unsupported aggregateLabels function.");
    }

    private static ExpressionResult aggregateLabeledValueResult(ExpressionResult expResult, AggregateLabelsFuncFactory factory) {
        List<MQEValues> results = expResult.getResults();
        if (CollectionUtils.isEmpty(results)) {
            return expResult;
        }
        List<MQEValue> combineTo = results.get(0).getValues();
        for (int i = 0; i < combineTo.size(); ++i) {
            AggregateLabelsFunc aggregateLabelsFunc = factory.getAggregateLabelsFunc();
            for (MQEValues mQEValues : results) {
                MQEValue toCombine = mQEValues.getValues().get(i);
                if (toCombine.isEmptyValue()) continue;
                aggregateLabelsFunc.combine(toCombine.getDoubleValue());
            }
            MQEValue mqeValue = combineTo.get(i);
            mqeValue.setTraceID(null);
            mqeValue.setEmptyValue(true);
            mqeValue.setDoubleValue(0.0);
            Double d = aggregateLabelsFunc.getResult();
            if (d == null) continue;
            mqeValue.setEmptyValue(false);
            mqeValue.setDoubleValue(d);
        }
        MQEValues mqeValues = new MQEValues();
        mqeValues.setMetric(new Metadata());
        mqeValues.setValues(combineTo);
        expResult.setResults(Collections.singletonList(mqeValues));
        expResult.setLabeledResult(false);
        return expResult;
    }
}

