/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.grammar.MQEParserBaseVisitor;
import org.apache.skywalking.mqe.rt.operation.AggregateLabelsOp;
import org.apache.skywalking.mqe.rt.operation.AggregationOp;
import org.apache.skywalking.mqe.rt.operation.BinaryOp;
import org.apache.skywalking.mqe.rt.operation.CompareOp;
import org.apache.skywalking.mqe.rt.operation.LogicalFunctionOp;
import org.apache.skywalking.mqe.rt.operation.MathematicalFunctionOp;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQEVisitorBase
extends MQEParserBaseVisitor<ExpressionResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQEVisitorBase.class);
    public static final String GENERAL_LABEL_NAME = "_";

    public ExpressionResult visitParensOp(MQEParser.ParensOpContext ctx) {
        return (ExpressionResult)this.visit((ParseTree)ctx.expression());
    }

    public ExpressionResult visitAddSubOp(MQEParser.AddSubOpContext ctx) {
        ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getError())) {
            return left;
        }
        ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getError())) {
            return right;
        }
        int opType = ctx.addSub().getStart().getType();
        try {
            return BinaryOp.doBinaryOp(left, right, opType);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitMulDivModOp(MQEParser.MulDivModOpContext ctx) {
        ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getError())) {
            return left;
        }
        ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getError())) {
            return right;
        }
        int opType = ctx.mulDivMod().getStart().getType();
        try {
            return BinaryOp.doBinaryOp(left, right, opType);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitScalar(MQEParser.ScalarContext ctx) {
        ExpressionResult result = new ExpressionResult();
        double value = Double.parseDouble(ctx.getText());
        MQEValue mqeValue = new MQEValue();
        mqeValue.setDoubleValue(value);
        mqeValue.setEmptyValue(false);
        MQEValues mqeValues = new MQEValues();
        mqeValues.getValues().add(mqeValue);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.SINGLE_VALUE);
        return result;
    }

    public ExpressionResult visitAggregationOp(MQEParser.AggregationOpContext ctx) {
        int opType = ctx.aggregation().getStart().getType();
        ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (StringUtil.isNotEmpty((String)expResult.getError())) {
            return expResult;
        }
        try {
            return AggregationOp.doAggregationOp(expResult, opType);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitAggregateLabelsOp(MQEParser.AggregateLabelsOpContext ctx) {
        int funcType = ctx.aggregateLabelsFunc().getStart().getType();
        ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (StringUtil.isNotEmpty((String)expResult.getError())) {
            return expResult;
        }
        if (!expResult.isLabeledResult()) {
            expResult.setError("The result of expression [" + ctx.expression().getText() + "] is not a labeled result.");
            return expResult;
        }
        try {
            return AggregateLabelsOp.doAggregateLabelsOp(expResult, funcType);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitMathematicalOperator0OP(MQEParser.MathematicalOperator0OPContext ctx) {
        int opType = ctx.mathematical_operator0().getStart().getType();
        ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (StringUtil.isNotEmpty((String)expResult.getError())) {
            return expResult;
        }
        try {
            return MathematicalFunctionOp.doFunction0Op(expResult, opType);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitMathematicalOperator1OP(MQEParser.MathematicalOperator1OPContext ctx) {
        int opType = ctx.mathematical_operator1().getStart().getType();
        ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (StringUtil.isNotEmpty((String)expResult.getError())) {
            return expResult;
        }
        try {
            return MathematicalFunctionOp.doFunction1Op(expResult, opType, Integer.parseInt(ctx.parameter().INTEGER().getText()));
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitTopNOP(MQEParser.TopNOPContext ctx) {
        return (ExpressionResult)this.visit((ParseTree)ctx.metric());
    }

    public ExpressionResult visitRelablesOP(MQEParser.RelablesOPContext ctx) {
        List<MQEValues> mqeValuesList;
        ExpressionResult result = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (!result.isLabeledResult()) {
            result.setError("The result of expression [" + ctx.expression().getText() + "] is not a labeled result.");
            return result;
        }
        List<Object> relabelList = Collections.emptyList();
        String newLabelValue = ctx.label().labelValue().getText();
        String labelValueTrim = newLabelValue.substring(1, newLabelValue.length() - 1);
        if (StringUtil.isNotBlank((String)labelValueTrim)) {
            relabelList = Arrays.asList(labelValueTrim.split(","));
        }
        if ((mqeValuesList = result.getResults()).size() != relabelList.size()) {
            result.setError("The number of relabels is not equal to the number of labels.");
            return result;
        }
        for (int i = 0; i < mqeValuesList.size(); ++i) {
            mqeValuesList.get(i).getMetric().getLabels().get(0).setValue((String)relabelList.get(i));
        }
        return result;
    }

    public ExpressionResult visitLogicalOperatorOP(MQEParser.LogicalOperatorOPContext ctx) {
        int opType = ctx.logical_operator().getStart().getType();
        try {
            return LogicalFunctionOp.doOP(opType, ctx.expressionList(), this);
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public ExpressionResult visitCompareOp(MQEParser.CompareOpContext ctx) {
        ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getError())) {
            return left;
        }
        ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getError())) {
            return right;
        }
        int opType = ctx.compare().getStart().getType();
        try {
            ExpressionResult result = CompareOp.doCompareOP(left, right, opType);
            if (ctx.parent == null) {
                result.setBoolResult(true);
            }
            return result;
        }
        catch (IllegalExpressionException e) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError(e.getMessage());
            return result;
        }
    }

    public abstract ExpressionResult visitMetric(MQEParser.MetricContext var1);
}

