/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Timestamp;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidReferenceException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public abstract class AbstractWrite<P extends GeneratedMessageV3> {
    protected long timestamp;
    protected final Object[] tags;
    protected final MetadataCache.EntityMetadata entityMetadata;

    public AbstractWrite(MetadataCache.EntityMetadata entityMetadata, long timestamp) {
        if (entityMetadata == null) {
            throw new IllegalArgumentException("metadata not found");
        }
        this.entityMetadata = entityMetadata;
        this.timestamp = timestamp;
        this.tags = new Object[this.entityMetadata.getTotalTags()];
    }

    AbstractWrite(MetadataCache.EntityMetadata entityMetadata) {
        this(entityMetadata, 0L);
    }

    public AbstractWrite<P> tag(String tagName, Serializable<BanyandbModel.TagValue> tagValue) throws BanyanDBException {
        Optional<MetadataCache.TagInfo> tagInfo = this.entityMetadata.findTagInfo(tagName);
        if (!tagInfo.isPresent()) {
            throw InvalidReferenceException.fromInvalidTag(tagName);
        }
        this.tags[tagInfo.get().getOffset()] = tagValue;
        return this;
    }

    P build() {
        if (this.timestamp <= 0L) {
            throw new IllegalArgumentException("timestamp is invalid.");
        }
        BanyandbCommon.Metadata metadata = BanyandbCommon.Metadata.newBuilder().setGroup(this.entityMetadata.getGroup()).setName(this.entityMetadata.getName()).build();
        Timestamp ts = Timestamp.newBuilder().setSeconds(this.timestamp / 1000L).setNanos((int)(this.timestamp % 1000L * 1000000L)).build();
        return this.build(metadata, ts);
    }

    protected abstract P build(BanyandbCommon.Metadata var1, Timestamp var2);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("group=").append(this.entityMetadata.getGroup()).append(", ").append("name=").append(this.entityMetadata.getName()).append(", ").append("timestamp=").append(this.timestamp).append(", ");
        for (int i = 0; i < this.tags.length; ++i) {
            int index = i;
            Map<String, MetadataCache.TagInfo> tagMap = this.entityMetadata.getTagOffset();
            Optional<String> tagName = tagMap.keySet().stream().filter(name -> ((MetadataCache.TagInfo)tagMap.get(name)).getOffset() == index).findAny();
            if (!tagName.isPresent()) continue;
            stringBuilder.append(tagName.get()).append("=").append(((Serializable)this.tags[i]).serialize()).append(", ");
        }
        return stringBuilder.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

